SET QUOTED_IDENTIFIER ON
GO

/* SQL Data Pump */
/* RELEASE 2 */

 --Set Script Name
 IF OBJECT_ID('tempdb..#SCRIPT') IS NOT NULL
    DROP TABLE #SCRIPT

 CREATE TABLE 
        #SCRIPT
       ([ScriptName]          VARCHAR(MAX) COLLATE DATABASE_DEFAULT,
        [CompatibleVersion]   VARCHAR(50),
        [MajorVersion]        INT,
        [MinorVersion]        INT,
        [Build]               INT,
        [Revision]            INT)

--Create Script Entry. This can be updated below
SET NOCOUNT ON
INSERT
  INTO #SCRIPT
      ([ScriptName],
       [CompatibleVersion],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision])
VALUES('020 SQL Data Pump.sql',
       'Build 5.2.1.1',
       5,
       2,
       1,
       1)
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.1.24
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 24, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.2.1.24'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
IF EXISTS (SELECT TOP 1 1 FROM SYS.objects WHERE Upper(name)='ACTIONFLAG')
	BEGIN
		IF NOT EXISTS (SELECT TOP 1 1 FROM ActionFlag WHERE ActionFlagID=0)
			BEGIN
				INSERT INTO ActionFlag (ActionFlagID,Description,IsActive) VALUES (0,'White Flag',1)
			END
		ELSE
			BEGIN
				IF EXISTS (SELECT TOP 1 1 FROM ActionFlag WHERE ActionFlagID=0 AND [Description] LIKE '%Description%')
				
					UPDATE ActionFlag SET [Description] ='White Flag' WHERE ActionFlagID=0
			END
	END

GO

IF EXISTS (SELECT TOP 1 1 FROM SYS.objects WHERE Upper(name)='ACTIONFLAG')
	BEGIN
		IF NOT EXISTS (SELECT TOP 1 1 FROM ActionFlag WHERE ActionFlagID=1)
			BEGIN
				INSERT INTO ActionFlag (ActionFlagID,Description,IsActive) VALUES (1,'Blue Flag',1)
			END
		ELSE
			BEGIN
				IF EXISTS (SELECT TOP 1 1 FROM ActionFlag WHERE ActionFlagID=1 AND [Description] LIKE '%Description%')
				
					UPDATE ActionFlag SET [Description] ='Blue Flag' WHERE ActionFlagID=1
			END
	END

GO

IF EXISTS (SELECT TOP 1 1 FROM SYS.objects WHERE Upper(name)='ACTIONFLAG')
	BEGIN
		IF NOT EXISTS (SELECT TOP 1 1 FROM ActionFlag WHERE ActionFlagID=2)
			BEGIN
				INSERT INTO ActionFlag (ActionFlagID,Description,IsActive) VALUES (2,'Orange Flag',1)
			END
		ELSE
			BEGIN
				IF EXISTS (SELECT TOP 1 1 FROM ActionFlag WHERE ActionFlagID=2 AND [Description] LIKE '%Description%')
				
					UPDATE ActionFlag SET [Description] ='Orange Flag' WHERE ActionFlagID=2
			END
	END

GO
IF EXISTS (SELECT TOP 1 1 FROM SYS.objects WHERE Upper(name)='ACTIONFLAG')
	BEGIN
		IF NOT EXISTS (SELECT TOP 1 1 FROM ActionFlag WHERE ActionFlagID=3)
			BEGIN
				INSERT INTO ActionFlag (ActionFlagID,Description,IsActive) VALUES (3,'Red Flag',1)
			END
		ELSE
			BEGIN
				IF EXISTS (SELECT TOP 1 1 FROM ActionFlag WHERE ActionFlagID=3 AND [Description] LIKE '%Description%')
				
					UPDATE ActionFlag SET [Description] ='Red Flag' WHERE ActionFlagID=3
			END
	END

GO
IF EXISTS (SELECT TOP 1 1 FROM SYS.objects WHERE Upper(name)='ACTIONFLAG')
	BEGIN
		IF NOT EXISTS (SELECT TOP 1 1 FROM ActionFlag WHERE ActionFlagID=4)
			BEGIN
				INSERT INTO ActionFlag (ActionFlagID,Description,IsActive) VALUES (4,'Green Flag',1)
			END
		ELSE
			BEGIN
				IF EXISTS (SELECT TOP 1 1 FROM ActionFlag WHERE ActionFlagID=4 AND [Description] LIKE '%Description%')
				
					UPDATE ActionFlag SET [Description] ='Green Flag' WHERE ActionFlagID=4
			END
	END

GO
IF EXISTS (SELECT TOP 1 1 FROM SYS.objects WHERE Upper(name)='ACTIONFLAG')
	BEGIN
		IF NOT EXISTS (SELECT TOP 1 1 FROM ActionFlag WHERE ActionFlagID=5)
			BEGIN
				INSERT INTO ActionFlag (ActionFlagID,Description,IsActive) VALUES (5,'Black Flag',1)
			END
		ELSE
			BEGIN
				IF EXISTS (SELECT TOP 1 1 FROM ActionFlag WHERE ActionFlagID=5 AND [Description] LIKE '%Description%')
				
					UPDATE ActionFlag SET [Description] ='Black Flag' WHERE ActionFlagID=5
			END
	END

GO
IF EXISTS (SELECT TOP 1 1 FROM SYS.objects WHERE Upper(name)='ACTIONFLAG')
	BEGIN
		IF NOT EXISTS (SELECT TOP 1 1 FROM ActionFlag WHERE ActionFlagID=6)
			BEGIN
				INSERT INTO ActionFlag (ActionFlagID,Description,IsActive) VALUES (6,'Yellow Flag',1)
			END
		ELSE
			BEGIN
				IF EXISTS (SELECT TOP 1 1 FROM ActionFlag WHERE ActionFlagID=6 AND [Description] LIKE '%Description%')
				
					UPDATE ActionFlag SET [Description] ='Yellow Flag' WHERE ActionFlagID=6
			END
	END

GO
IF EXISTS (SELECT TOP 1 1 FROM SYS.objects WHERE Upper(name)='ACTIONFLAG')
	BEGIN
		IF NOT EXISTS (SELECT TOP 1 1 FROM ActionFlag WHERE ActionFlagID=7)
			BEGIN
				INSERT INTO ActionFlag (ActionFlagID,Description,IsActive) VALUES (7,'Brown Flag',0)
			END
		ELSE
			BEGIN
				IF EXISTS (SELECT TOP 1 1 FROM ActionFlag WHERE ActionFlagID=7 AND [Description] LIKE '%Description%')
				
					UPDATE ActionFlag SET [Description] ='Brown Flag' WHERE ActionFlagID=7
			END
	END

GO
IF EXISTS (SELECT TOP 1 1 FROM SYS.objects WHERE Upper(name)='ACTIONFLAG')
	BEGIN
		IF NOT EXISTS (SELECT TOP 1 1 FROM ActionFlag WHERE ActionFlagID=8)
			BEGIN
				INSERT INTO ActionFlag (ActionFlagID,Description,IsActive) VALUES (8,'Pink Flag',0)
			END
		ELSE
			BEGIN
				IF EXISTS (SELECT TOP 1 1 FROM ActionFlag WHERE ActionFlagID=8 AND [Description] LIKE '%Description%')
				
					UPDATE ActionFlag SET [Description] ='Pink Flag' WHERE ActionFlagID=8
			END
	END

GO
IF EXISTS (SELECT TOP 1 1 FROM SYS.objects WHERE Upper(name)='ACTIONFLAG')
	BEGIN
		IF NOT EXISTS (SELECT TOP 1 1 FROM ActionFlag WHERE ActionFlagID=9)
			BEGIN
				INSERT INTO ActionFlag (ActionFlagID,Description,IsActive) VALUES (9,'Grey Flag',0)
			END
		ELSE
			BEGIN
				IF EXISTS (SELECT TOP 1 1 FROM ActionFlag WHERE ActionFlagID=9 AND [Description] LIKE '%Description%')
				
					UPDATE ActionFlag SET [Description] ='Grey Flag' WHERE ActionFlagID=9
			END
	END

GO
IF EXISTS (SELECT TOP 1 1 FROM SYS.objects WHERE Upper(name)='ACTIONFLAG')
	BEGIN
		IF NOT EXISTS (SELECT TOP 1 1 FROM ActionFlag WHERE ActionFlagID=10)
			BEGIN
				INSERT INTO ActionFlag (ActionFlagID,Description,IsActive) VALUES (10,'Voilet Flag',0)
			END
		ELSE
			BEGIN
				IF EXISTS (SELECT TOP 1 1 FROM ActionFlag WHERE ActionFlagID=10 AND [Description] LIKE '%Description%')
				
					UPDATE ActionFlag SET [Description] ='Voilet Flag' WHERE ActionFlagID=10
			END
	END

GO
IF EXISTS (SELECT TOP 1 1 FROM SYS.objects WHERE Upper(name)='ACTIONFLAG')
	BEGIN
		IF NOT EXISTS (SELECT TOP 1 1 FROM ActionFlag WHERE ActionFlagID=11)
			BEGIN
				INSERT INTO ActionFlag (ActionFlagID,Description,IsActive) VALUES (11,'Pale Green Flag',0)
			END
		ELSE
			BEGIN
				IF EXISTS (SELECT TOP 1 1 FROM ActionFlag WHERE ActionFlagID=11 AND [Description] LIKE '%Description%')
				
					UPDATE ActionFlag SET [Description] ='Pale Green Flag' WHERE ActionFlagID=11
			END
	END

GO
IF EXISTS (SELECT TOP 1 1 FROM SYS.objects WHERE Upper(name)='ACTIONFLAG')
	BEGIN
		IF NOT EXISTS (SELECT TOP 1 1 FROM ActionFlag WHERE ActionFlagID=12)
			BEGIN
				INSERT INTO ActionFlag (ActionFlagID,Description,IsActive) VALUES (12,'Navy Blue Flag',0)
			END
		ELSE
			BEGIN
				IF EXISTS (SELECT TOP 1 1 FROM ActionFlag WHERE ActionFlagID=12 AND [Description] LIKE '%Description%')
				
					UPDATE ActionFlag SET [Description] ='Navy Blue Flag' WHERE ActionFlagID=12
			END
	END

GO
IF EXISTS (SELECT TOP 1 1 FROM SYS.objects WHERE Upper(name)='ACTIONFLAG')
	BEGIN
		IF NOT EXISTS (SELECT TOP 1 1 FROM ActionFlag WHERE ActionFlagID=13)
			BEGIN
				INSERT INTO ActionFlag (ActionFlagID,Description,IsActive) VALUES (13,'Cyan Flag',0)
			END
		ELSE
			BEGIN
				IF EXISTS (SELECT TOP 1 1 FROM ActionFlag WHERE ActionFlagID=13 AND [Description] LIKE '%Description%')
				
					UPDATE ActionFlag SET [Description] ='Cyan Flag' WHERE ActionFlagID=13
			END
	END
GO

INSERT
  INTO [dbo].[TemplateActions]
      ([ACTIONCODE],
       [DESC],
       [WKTCODE],
       [ACTTYPE],
       [ACTIONCATEGORY],
       [STATUS],
       [PROCESSTYPE],
       [PUBLISHER],
       [UPDATEFIELD],
       [UPDATEVALUE],
       [HIGHLIGHTED],
       [MILESTONETYPE],
       [PRIORITY],
       [NEXTACTIONOPTIONAL],
       [BILLABLE],
       [EMAIL],
       [BILLDESCRIPTION],
       [AssignActionTo],
       [ASSIGNHANDLER],
       [AssignTeamActionTo],
       [ASSIGNTEAM],
       [Description])
SELECT NW.[ACTIONCODE],
       NW.[DESC],
       NW.[WKTCODE],
       NW.[ACTTYPE],
       NW.[ACTIONCATEGORY],
       NW.[STATUS],
       NW.[PROCESSTYPE],
       NW.[PUBLISHER],
       NW.[UPDATEFIELD],
       NW.[UPDATEVALUE],
       NW.[HIGHLIGHTED],
       NW.[MILESTONETYPE],
       NW.[PRIORITY],
       NW.[NEXTACTIONOPTIONAL],
       NW.[BILLABLE],
       NW.[EMAIL],
       NW.[BILLDESCRIPTION],
       NW.[AssignActionTo],
       NW.[ASSIGNHANDLER],
       NW.[AssignTeamActionTo],
       NW.[ASSIGNTEAM],
       NW.[Description]
  FROM (SELECT 'ADMKD' AS [ACTIONCODE],
               'Saved Document' AS [DESC],
               'SYS' AS [WKTCODE],
               'A' AS [ACTTYPE],
               'A' AS [ACTIONCATEGORY],
               'NA' AS [STATUS],
               'I' AS [PROCESSTYPE],
               'N' AS [PUBLISHER],
               '' AS [UPDATEFIELD],
               '' AS [UPDATEVALUE],
               'N' AS [HIGHLIGHTED],
               '' AS [MILESTONETYPE],
               'Normal' AS [PRIORITY],
               'Y' AS [NEXTACTIONOPTIONAL],
               'N' AS [BILLABLE],
               '' AS [EMAIL],
               '' AS [BILLDESCRIPTION],
               'L' AS [AssignActionTo],
               '' AS [ASSIGNHANDLER],
               'L' AS [AssignTeamActionTo],
               '' AS [ASSIGNTEAM],
               'Saved Document' AS [Description]) NW
       LEFT OUTER JOIN [dbo].[TemplateActions] TAC
                    ON TAC.[ACTIONCODE] = NW.[ACTIONCODE]
 WHERE TAC.[ACTIONCODE] IS NULL

GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.1.24
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.1.28
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 28, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.2.1.28'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
--Fix some naff transactions. Only found 3 of these in RDJ, none in IF and none in MOP
DECLARE @COMMAND VARCHAR(MAX)

IF [dbo].[ISSAM4]() = 1
  BEGIN
    SET @COMMAND = '
UPDATE TRN
   SET TRN.[FeeEarner] = MAT.[FECode]
  FROM [dbo].[Transactions] TRN
       LEFT OUTER JOIN [dbo].[matters] MAT
                    ON MAT.[Code] = TRN.[MatterCode]
 WHERE TRN.[FeeEarner] IS NULL
   AND TRN.[CorrectionInd] = ''L''
   AND (   (    TRN.[XnType] = ''I''
            AND TRN.[RecType] = ''H'')
        OR (    TRN.[XnType] = ''J''
            AND TRN.[RecType] = ''D''))
   AND TRN.[DebtorsValueOS] > 0'

    EXEC (@COMMAND)
  END
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.1.28
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.1.33
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 33, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.2.1.33'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/

-- This had been inserted into ky_NETCCInsertDiaryDetails!?!?
IF NOT EXISTS
  (SELECT Top 1 1
     FROM [dbo].[TemplateActions] TAC
    WHERE TAC.[ACTIONCODE] = 'PHO')
BEGIN
  INSERT
    INTO [dbo].[TemplateActions]
        ([ACTIONCODE],
         [DESC],
         [WKTCODE],
         [ACTTYPE],
         [ACTIONCATEGORY],
         [STATUS],
         [PROCESSTYPE],
         [PUBLISHER],
         [PRIORITY],
         [NEXTACTIONOPTIONAL],
         [ASSIGNACTIONTO],
         [ASSIGNTEAMACTIONTO],
         [CHARGEVALUE])
  VALUES('PHO',
         'Phone Message',
         'SYS',
         'N',
         'T',
         'NA',
         'I',
         'N',
         'Normal',
         'Y',
         'L',
         'L',
         0)
END
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.1.33
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.1.40
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 40, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.2.1.40'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
IF NOT EXISTS(SELECT TOP 1 1 FROM Settings where KeyName = 'AllowAssignToClosed')
BEGIN
INSERT INTO Settings(KeyName,KeyValue) VALUES('AllowAssignToClosed','False')
END

GO

IF NOT EXISTS(SELECT TOP 1 1 FROM Settings where KeyName = 'RoundupUnits')
BEGIN
INSERT INTO Settings(KeyName,KeyValue) VALUES('RoundupUnits','False')
END

GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.1.40
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.1.45
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 45, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.2.1.45'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
INSERT
  INTO [dbo].[TemplateActions]
      ([ACTIONCODE],
       [DESC],
       [WKTCODE],
       [ACTTYPE],
       [ACTIONCATEGORY],
       [STATUS],
       [PROCESSTYPE],
       [PUBLISHER],
       [UPDATEFIELD],
       [UPDATEVALUE],
       [HIGHLIGHTED],
       [MILESTONETYPE],
       [PRIORITY],
       [NEXTACTIONOPTIONAL],
       [BILLABLE],
       [EMAIL],
       [BILLDESCRIPTION],
       [AssignActionTo],
       [ASSIGNHANDLER],
       [AssignTeamActionTo],
       [ASSIGNTEAM],
       [Description])
SELECT NW.[ACTIONCODE],
       NW.[DESC],
       NW.[WKTCODE],
       NW.[ACTTYPE],
       NW.[ACTIONCATEGORY],
       NW.[STATUS],
       NW.[PROCESSTYPE],
       NW.[PUBLISHER],
       NW.[UPDATEFIELD],
       NW.[UPDATEVALUE],
       NW.[HIGHLIGHTED],
       NW.[MILESTONETYPE],
       NW.[PRIORITY],
       NW.[NEXTACTIONOPTIONAL],
       NW.[BILLABLE],
       NW.[EMAIL],
       NW.[BILLDESCRIPTION],
       NW.[AssignActionTo],
       NW.[ASSIGNHANDLER],
       NW.[AssignTeamActionTo],
       NW.[ASSIGNTEAM],
       NW.[Description]
  FROM (SELECT 'ADMKD' AS [ACTIONCODE],
               'Saved Document' AS [DESC],
               'SYS' AS [WKTCODE],
               'A' AS [ACTTYPE],
               'A' AS [ACTIONCATEGORY],
               'NA' AS [STATUS],
               'I' AS [PROCESSTYPE],
               'N' AS [PUBLISHER],
               '' AS [UPDATEFIELD],
               '' AS [UPDATEVALUE],
               'N' AS [HIGHLIGHTED],
               '' AS [MILESTONETYPE],
               'Normal' AS [PRIORITY],
               'Y' AS [NEXTACTIONOPTIONAL],
               'N' AS [BILLABLE],
               '' AS [EMAIL],
               '' AS [BILLDESCRIPTION],
               'L' AS [AssignActionTo],
               '' AS [ASSIGNHANDLER],
               'L' AS [AssignTeamActionTo],
               '' AS [ASSIGNTEAM],
               'Saved Document' AS [Description]) NW
       LEFT OUTER JOIN [dbo].[TemplateActions] TAC
                    ON TAC.[ACTIONCODE] = NW.[ACTIONCODE]
 WHERE TAC.[ACTIONCODE] IS NULL
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.1.45
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.1.56
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 56, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.2.1.56'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/

IF NOT EXISTS
  (SELECT TOP 1 1
     FROM [dbo].[TemplateActions] TAC
    WHERE TAC.[ACTIONCODE] = 'ADMAP')
BEGIN
INSERT 
  INTO [dbo].[TemplateActions] 
      ([ACTIONCODE],
       [DESC],
       [WKTCODE],
       [ACTTYPE],
       [ACTIONCATEGORY],
       [STATUS],
       [PROCESSTYPE],
       [PUBLISHER],
       [UPDATEFIELD],
       [UPDATEVALUE],
       [HIGHLIGHTED],
       [MILESTONETYPE],
       [PRIORITY],
       [NEXTACTIONOPTIONAL],
       [BILLABLE],
       [EMAIL],
       [BILLDESCRIPTION],
       [AssignActionTo],
       [ASSIGNHANDLER],
       [AssignTeamActionTo],
       [ASSIGNTEAM],
       [ChargeValue],
       [Arrangement],
       [ChargeInterest],
       [Description],
       [AutoPopulate],
       [RequiredAction],
       [AuthorisationRequired],
       [Authby],
       [ConfirmByPW],
       [Flag])
VALUES('ADMAP',
       'Appointment',
       'SYS',
       'N',
       'P',
       'NA',
       'I',
       'N',
       '',
       '',
       'N',
       '',
       'Normal',
       'Y',
       'N',
       '',
       '',
       NULL,
       '',
       NULL,
       '',
       CAST(0 AS Decimal(18, 0)),
       NULL,
       NULL,
       'Appointment',
       NULL,
       NULL,
       NULL,
       NULL,
       NULL,
       NULL)
END
GO
IF NOT EXISTS
  (SELECT TOP 1 1
     FROM [dbo].[TemplateActions] TAC
    WHERE TAC.[ACTIONCODE] = 'ADMCS')
BEGIN
INSERT
  INTO [dbo].[TemplateActions]
      ([ACTIONCODE],
       [DESC],
       [WKTCODE],
       [ACTTYPE],
       [ACTIONCATEGORY],
       [STATUS],
       [PROCESSTYPE],
       [PUBLISHER],
       [UPDATEFIELD],
       [UPDATEVALUE],
       [HIGHLIGHTED],
       [MILESTONETYPE],
       [PRIORITY],
       [NEXTACTIONOPTIONAL],
       [BILLABLE],
       [EMAIL],
       [BILLDESCRIPTION],
       [AssignActionTo],
       [ASSIGNHANDLER],
       [AssignTeamActionTo],
       [ASSIGNTEAM],
       [ChargeValue],
       [Arrangement],
       [ChargeInterest],
       [Description],
       [AutoPopulate],
       [RequiredAction],
       [AuthorisationRequired],
       [Authby],
       [ConfirmByPW],
       [Flag])
VALUES('ADMCS',
       'Conflict Search',
       'SYS',
       'A',
       'A',
       'NA',
       'I',
       'N',
       '',
       '',
       'N',
       '',
       'Normal',
       'Y',
       '',
       '',
       '',
       'L',
       '',
       'L',
       '', CAST(0 AS Decimal(18, 0)),
       '',
       '',
       NULL,
       NULL,
       NULL,
       NULL,
       NULL,
       NULL,
       NULL)
END
GO
IF NOT EXISTS
  (SELECT TOP 1 1
     FROM [dbo].[TemplateActions] TAC
    WHERE TAC.[ACTIONCODE] = 'ADMKD')
BEGIN
INSERT
  INTO [dbo].[TemplateActions]
      ([ACTIONCODE],
       [DESC],
       [WKTCODE],
       [ACTTYPE],
       [ACTIONCATEGORY],
       [STATUS],
       [PROCESSTYPE],
       [PUBLISHER],
       [UPDATEFIELD],
       [UPDATEVALUE],
       [HIGHLIGHTED],
       [MILESTONETYPE],
       [PRIORITY],
       [NEXTACTIONOPTIONAL],
       [BILLABLE],
       [EMAIL],
       [BILLDESCRIPTION],
       [AssignActionTo],
       [ASSIGNHANDLER],
       [AssignTeamActionTo],
       [ASSIGNTEAM],
       [ChargeValue],
       [Arrangement],
       [ChargeInterest],
       [Description],
       [AutoPopulate],
       [RequiredAction],
       [AuthorisationRequired],
       [Authby],
       [ConfirmByPW],
       [Flag])
VALUES('ADMKD',
       'Saved Document',
       'SYS',
       'A',
       'A',
       'NA',
       'I',
       'N',
       '',
       '',
       'N',
       '',
       'Normal',
       'Y',
       'N',
       '',
       '',
       'L',
       '',
       'L',
       '', CAST(0 AS Decimal(18, 0)),
       NULL,
       NULL,
       'Saved Document',
       NULL,
       NULL,
       NULL,
       NULL,
       NULL,
       NULL)
END
GO
IF NOT EXISTS
  (SELECT TOP 1 1
     FROM [dbo].[TemplateActions] TAC
    WHERE TAC.[ACTIONCODE] = 'ADMSD')
BEGIN
INSERT
  INTO [dbo].[TemplateActions]
      ([ACTIONCODE],
       [DESC],
       [WKTCODE],
       [ACTTYPE],
       [ACTIONCATEGORY],
       [STATUS],
       [PROCESSTYPE],
       [PUBLISHER],
       [UPDATEFIELD],
       [UPDATEVALUE],
       [HIGHLIGHTED],
       [MILESTONETYPE],
       [PRIORITY],
       [NEXTACTIONOPTIONAL],
       [BILLABLE],
       [EMAIL],
       [BILLDESCRIPTION],
       [AssignActionTo],
       [ASSIGNHANDLER],
       [AssignTeamActionTo],
       [ASSIGNTEAM],
       [ChargeValue],
       [Arrangement],
       [ChargeInterest],
       [Description],
       [AutoPopulate],
       [RequiredAction],
       [AuthorisationRequired],
       [Authby],
       [ConfirmByPW],
       [Flag])
VALUES('ADMSD',
       'Statute Date',
       'SYS',
       'N',
       'S',
       'NA',
       'I',
       'N',
       '',
       '',
       '',
       '',
       'Normal',
       'Y',
       '',
       '',
       '',
       'L',
       '',
       'L',
       '', CAST(0 AS Decimal(18, 0)),
       '',
       '',
       '',
       '',
       'Y',
       '',
       '',
       '',
       NULL)
END
GO
IF NOT EXISTS
  (SELECT TOP 1 1
     FROM [dbo].[TemplateActions] TAC
    WHERE TAC.[ACTIONCODE] = 'ADMUD')
BEGIN
INSERT
  INTO [dbo].[TemplateActions]
      ([ACTIONCODE],
       [DESC],
       [WKTCODE],
       [ACTTYPE],
       [ACTIONCATEGORY],
       [STATUS],
       [PROCESSTYPE],
       [PUBLISHER],
       [UPDATEFIELD],
       [UPDATEVALUE],
       [HIGHLIGHTED],
       [MILESTONETYPE],
       [PRIORITY],
       [NEXTACTIONOPTIONAL],
       [BILLABLE],
       [EMAIL],
       [BILLDESCRIPTION],
       [AssignActionTo],
       [ASSIGNHANDLER],
       [AssignTeamActionTo],
       [ASSIGNTEAM],
       [ChargeValue],
       [Arrangement],
       [ChargeInterest],
       [Description],
       [AutoPopulate],
       [RequiredAction],
       [AuthorisationRequired],
       [Authby],
       [ConfirmByPW],
       [Flag])
VALUES('ADMUD',
       'Undertakings',
       'SYS',
       'N',
       'U',
       'NA',
       'I',
       'N',
       '',
       '',
       '',
       '',
       'Normal',
       'Y',
       '',
       '',
       '',
       'L',
       '',
       'L',
       '', CAST(0 AS Decimal(18, 0)),
       '',
       '',
       '',
       '',
       'Y',
       '',
       '',
       '',
       NULL)
END
GO
IF NOT EXISTS
  (SELECT TOP 1 1
     FROM [dbo].[TemplateActions] TAC
    WHERE TAC.[ACTIONCODE] = 'APP')
BEGIN
INSERT
  INTO [dbo].[TemplateActions]
      ([ACTIONCODE],
       [DESC],
       [WKTCODE],
       [ACTTYPE],
       [ACTIONCATEGORY],
       [STATUS],
       [PROCESSTYPE],
       [PUBLISHER],
       [UPDATEFIELD],
       [UPDATEVALUE],
       [HIGHLIGHTED],
       [MILESTONETYPE],
       [PRIORITY],
       [NEXTACTIONOPTIONAL],
       [BILLABLE],
       [EMAIL],
       [BILLDESCRIPTION],
       [AssignActionTo],
       [ASSIGNHANDLER],
       [AssignTeamActionTo],
       [ASSIGNTEAM],
       [ChargeValue],
       [Arrangement],
       [ChargeInterest],
       [Description],
       [AutoPopulate],
       [RequiredAction],
       [AuthorisationRequired],
       [Authby],
       [ConfirmByPW],
       [Flag])
VALUES('APP',
       'Outlook Appointment',
       'SYS',
       'N',
       'P',
       'NA',
       'I',
       'N',
       '',
       '',
       '',
       '',
       'Normal',
       'Y',
       '',
       '',
       '',
       NULL,
       '',
       NULL,
       '', CAST(0 AS Decimal(18, 0)),
       NULL,
       NULL,
       'Outlook Appointment',
       NULL,
       NULL,
       NULL,
       NULL,
       NULL,
       NULL)
END
GO
IF NOT EXISTS
  (SELECT TOP 1 1
     FROM [dbo].[TemplateActions] TAC
    WHERE TAC.[ACTIONCODE] = 'D0001')
BEGIN
INSERT
  INTO [dbo].[TemplateActions]
      ([ACTIONCODE],
       [DESC],
       [WKTCODE],
       [ACTTYPE],
       [ACTIONCATEGORY],
       [STATUS],
       [PROCESSTYPE],
       [PUBLISHER],
       [UPDATEFIELD],
       [UPDATEVALUE],
       [HIGHLIGHTED],
       [MILESTONETYPE],
       [PRIORITY],
       [NEXTACTIONOPTIONAL],
       [BILLABLE],
       [EMAIL],
       [BILLDESCRIPTION],
       [AssignActionTo],
       [ASSIGNHANDLER],
       [AssignTeamActionTo],
       [ASSIGNTEAM],
       [ChargeValue],
       [Arrangement],
       [ChargeInterest],
       [Description],
       [AutoPopulate],
       [RequiredAction],
       [AuthorisationRequired],
       [Authby],
       [ConfirmByPW],
       [Flag])
VALUES('D0001',
       'Digital Dictation',
       'SYS',
       'N',
       'D',
       'NA',
       'I',
       'N',
       '',
       '',
       '',
       '',
       'Normal',
       'Y',
       '',
       '',
       '',
       NULL,
       '',
       NULL,
       '', CAST(0 AS Decimal(18, 0)),
       NULL,
       NULL,
       'Digital Dictation',
       NULL,
       NULL,
       NULL,
       NULL,
       NULL,
       NULL)
END
GO
IF NOT EXISTS
  (SELECT TOP 1 1
     FROM [dbo].[TemplateActions] TAC
    WHERE TAC.[ACTIONCODE] = 'DB01')
BEGIN
INSERT
  INTO [dbo].[TemplateActions]
      ([ACTIONCODE],
       [DESC],
       [WKTCODE],
       [ACTTYPE],
       [ACTIONCATEGORY],
       [STATUS],
       [PROCESSTYPE],
       [PUBLISHER],
       [UPDATEFIELD],
       [UPDATEVALUE],
       [HIGHLIGHTED],
       [MILESTONETYPE],
       [PRIORITY],
       [NEXTACTIONOPTIONAL],
       [BILLABLE],
       [EMAIL],
       [BILLDESCRIPTION],
       [AssignActionTo],
       [ASSIGNHANDLER],
       [AssignTeamActionTo],
       [ASSIGNTEAM],
       [ChargeValue],
       [Arrangement],
       [ChargeInterest],
       [Description],
       [AutoPopulate],
       [RequiredAction],
       [AuthorisationRequired],
       [Authby],
       [ConfirmByPW],
       [Flag])
VALUES('DB01',
       'Draft Bill Created',
       'SYS',
       'N',
       'A',
       'NA',
       'I',
       'N',
       '',
       '',
       'N',
       '',
       'Normal',
       'Y',
       'N',
       '',
       '',
       '',
       '',
       '',
       '', CAST(0 AS Decimal(18, 0)),
       '',
       '',
       'Draft Bill Created',
       NULL,
       NULL,
       NULL,
       NULL,
       NULL,
       NULL)
END
GO
IF NOT EXISTS
  (SELECT TOP 1 1
     FROM [dbo].[TemplateActions] TAC
    WHERE TAC.[ACTIONCODE] = 'EMI')
BEGIN
INSERT
  INTO [dbo].[TemplateActions]
      ([ACTIONCODE],
       [DESC],
       [WKTCODE],
       [ACTTYPE],
       [ACTIONCATEGORY],
       [STATUS],
       [PROCESSTYPE],
       [PUBLISHER],
       [UPDATEFIELD],
       [UPDATEVALUE],
       [HIGHLIGHTED],
       [MILESTONETYPE],
       [PRIORITY],
       [NEXTACTIONOPTIONAL],
       [BILLABLE],
       [EMAIL],
       [BILLDESCRIPTION],
       [AssignActionTo],
       [ASSIGNHANDLER],
       [AssignTeamActionTo],
       [ASSIGNTEAM],
       [ChargeValue],
       [Arrangement],
       [ChargeInterest],
       [Description],
       [AutoPopulate],
       [RequiredAction],
       [AuthorisationRequired],
       [Authby],
       [ConfirmByPW],
       [Flag])
VALUES('EMI',
       'Outlook E-Mail',
       'SYS',
       'N',
       'E',
       'NA',
       'I',
       'N',
       '',
       '',
       '',
       '',
       'Normal',
       'Y',
       '',
       '',
       '',
       NULL,
       '',
       NULL,
       '', CAST(0 AS Decimal(18, 0)),
       NULL,
       NULL,
       'Outlook E-Mail',
       NULL,
       NULL,
       NULL,
       NULL,
       NULL,
       NULL)
END
GO
IF NOT EXISTS
  (SELECT TOP 1 1
     FROM [dbo].[TemplateActions] TAC
    WHERE TAC.[ACTIONCODE] = 'PHO')
BEGIN
INSERT
  INTO [dbo].[TemplateActions]
      ([ACTIONCODE],
       [DESC],
       [WKTCODE],
       [ACTTYPE],
       [ACTIONCATEGORY],
       [STATUS],
       [PROCESSTYPE],
       [PUBLISHER],
       [UPDATEFIELD],
       [UPDATEVALUE],
       [HIGHLIGHTED],
       [MILESTONETYPE],
       [PRIORITY],
       [NEXTACTIONOPTIONAL],
       [BILLABLE],
       [EMAIL],
       [BILLDESCRIPTION],
       [AssignActionTo],
       [ASSIGNHANDLER],
       [AssignTeamActionTo],
       [ASSIGNTEAM],
       [ChargeValue],
       [Arrangement],
       [ChargeInterest],
       [Description],
       [AutoPopulate],
       [RequiredAction],
       [AuthorisationRequired],
       [Authby],
       [ConfirmByPW],
       [Flag])
VALUES('PHO',
       'Phone Message',
       'SYS',
       'N',
       'A',
       'NA',
       'I',
       'N',
       '',
       '',
       '',
       '',
       'Normal',
       'Y',
       '',
       '',
       '',
       NULL,
       '',
       NULL,
       '', CAST(0 AS Decimal(18, 0)),
       NULL,
       NULL,
       'Phone Message',
       NULL,
       NULL,
       NULL,
       NULL,
       NULL,
       NULL)
END
GO
IF NOT EXISTS
  (SELECT TOP 1 1
     FROM [dbo].[TemplateActions] TAC
    WHERE TAC.[ACTIONCODE] = 'WDOC')
BEGIN
INSERT
  INTO [dbo].[TemplateActions]
      ([ACTIONCODE],
       [DESC],
       [WKTCODE],
       [ACTTYPE],
       [ACTIONCATEGORY],
       [STATUS],
       [PROCESSTYPE],
       [PUBLISHER],
       [UPDATEFIELD],
       [UPDATEVALUE],
       [HIGHLIGHTED],
       [MILESTONETYPE],
       [PRIORITY],
       [NEXTACTIONOPTIONAL],
       [BILLABLE],
       [EMAIL],
       [BILLDESCRIPTION],
       [AssignActionTo],
       [ASSIGNHANDLER],
       [AssignTeamActionTo],
       [ASSIGNTEAM],
       [ChargeValue],
       [Arrangement],
       [ChargeInterest],
       [Description],
       [AutoPopulate],
       [RequiredAction],
       [AuthorisationRequired],
       [Authby],
       [ConfirmByPW],
       [Flag])
VALUES('WDOC',
       'Word Document',
       'SYS',
       'N',
       'A',
       'NA',
       'I',
       'N',
       '',
       '',
       '',
       '',
       'Normal',
       'Y',
       '',
       '',
       '',
       'L',
       '',
       'L',
       '', CAST(0 AS Decimal(18, 0)),
       '',
       '',
       NULL,
       NULL,
       NULL,
       NULL,
       NULL,
       NULL,
       NULL)
END
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.1.56
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.1.58
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 58, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.2.1.58'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/

IF NOT EXISTS
  (SELECT TOP 1 1
     FROM [dbo].[TemplateActions] TAC
    WHERE TAC.[ACTIONCODE] = 'CH01')
BEGIN
INSERT
  INTO [dbo].[TemplateActions]
      ([ACTIONCODE],
       [DESC],
       [WKTCODE],
       [ACTTYPE],
       [ACTIONCATEGORY],
       [STATUS],
       [PROCESSTYPE],
       [PUBLISHER],
       [UPDATEFIELD],
       [UPDATEVALUE],
       [HIGHLIGHTED],
       [MILESTONETYPE],
       [PRIORITY],
       [NEXTACTIONOPTIONAL],
       [BILLABLE],
       [EMAIL],
       [BILLDESCRIPTION],
       [AssignActionTo],
       [ASSIGNHANDLER],
       [AssignTeamActionTo],
       [ASSIGNTEAM],
       [ChargeValue],
       [Arrangement],
       [ChargeInterest],
       [Description],
       [AutoPopulate],
       [RequiredAction],
       [AuthorisationRequired],
       [Authby],
       [ConfirmByPW],
       [Flag])
VALUES('CH01',
       'Cheque Requested',
       'SYS',
       'N',
       'A',
       'NA',
       'I',
       'N',
       '',
       '',
       'N',
       '',
       'Normal',
       'Y',
       'N',
       '',
       '',
       '',
       '',
       '',
       '', CAST(0 AS Decimal(18, 0)),
       '',
       '',
       'Cheque Requested',
       NULL,
       NULL,
       NULL,
       NULL,
       NULL,
       NULL)
END
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.1.58
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.1.63
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 63, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.2.1.63'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/

DELETE CTQ
  FROM [dbo].[ControlQueries] CTQ
 WHERE CTQ.[OwnerName] = 'MyCheques'

DELETE CTV
  FROM [dbo].[ControlViews] CTV
 WHERE CTV.[OwnerName] = 'MyCheques'

INSERT
  INTO [dbo].[ControlQueries]
      ([HANDLER],
       [Query],
       [ControlName],
       [OwnerName],
       [Default],
       [ControlSettings])
VALUES('',
       'Requested Cheques',
       'gCheques',
       'MyCheques',
       1,
       '<XtraSerializer>
  <property name="$GridControl">
    <property name="MRUFilters" iskey="true" value="0" />
    <property name="FilterString">[Status] = ''Request''</property>
    <property name="IsFilterEnabled">true</property>
  </property>
</XtraSerializer>')

INSERT
  INTO [dbo].[ControlQueries]
      ([HANDLER],
       [Query],
       [ControlName],
       [OwnerName],
       [Default],
       [ControlSettings])
VALUES('',
       'All Cheques',
       'gCheques',
       'MyCheques',
       0,
       '<XtraSerializer>
  <property name="$GridControl">
    <property name="MRUFilters" iskey="true" value="0" />
  </property>
</XtraSerializer>')

INSERT
  INTO [dbo].[ControlQueries]
      ([HANDLER],
       [Query],
       [ControlName],
       [OwnerName],
       [Default],
       [ControlSettings])
VALUES('',
       'Released Cheques',
       'gCheques',
       'MyCheques',
       0,
       '<XtraSerializer>
  <property name="$GridControl">
    <property name="MRUFilters" iskey="true" value="0" />
    <property name="FilterString">[Status] = ''Released''</property>
    <property name="IsFilterEnabled">true</property>
  </property>
</XtraSerializer>')

INSERT
  INTO [dbo].[ControlQueries]
      ([HANDLER],
       [Query],
       [ControlName],
       [OwnerName],
       [Default],
       [ControlSettings])
VALUES('',
       'Approved Cheques',
       'gCheques',
       'MyCheques',
       0,
       '<XtraSerializer>
  <property name="$GridControl">
    <property name="MRUFilters" iskey="true" value="0" />
    <property name="FilterString">[Status] = ''Approved''</property>
    <property name="IsFilterEnabled">true</property>
  </property>
</XtraSerializer>')

if [dbo].[ISSAM4]() = 1
  BEGIN
    INSERT
      INTO [dbo].[ControlQueries]
          ([HANDLER],
           [Query],
           [ControlName],
           [OwnerName],
           [Default],
           [ControlSettings])
    VALUES('',
           'Returned Cheques',
           'gCheques',
           'MyCheques',
           0,
           '<XtraSerializer>
      <property name="$GridControl">
        <property name="MRUFilters" iskey="true" value="0" />
        <property name="FilterString">[Status] = ''Returned''</property>
        <property name="IsFilterEnabled">true</property>
      </property>
    </XtraSerializer>')
  END

INSERT
  INTO [dbo].[ControlViews]
      ([Handler],
       [View],
       [ControlName],
       [OwnerName],
       [Default],
       [ControlSettings],
       [QueryID])
SELECT CTQ.[HANDLER],
       CTQ.[Query],
       CTQ.[ControlName],
       CTQ.[OwnerName],
       CTQ.[Default],
       '<XtraSerializer version="1.0" application="GridControl">
  <property name="#LayoutVersion" isnull="true" />
  <property name="$GridControl" iskey="true" value="GridControl">
    <property name="GroupCount">0</property>
    <property name="Columns" iskey="true" value="9">
      <property name="Item1" isnull="true" iskey="true">
        <property name="VisibleIndex">0</property>
        <property name="Name">colDate</property>
        <property name="FieldName">RequestDate</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item2" isnull="true" iskey="true">
        <property name="VisibleIndex">1</property>
        <property name="Name">colMatterCode</property>
        <property name="FieldName">MatterCode</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item3" isnull="true" iskey="true">
        <property name="VisibleIndex">1</property>
        <property name="Name">colStatus</property>
        <property name="Visible">false</property>
        <property name="FieldName">Status</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item4" isnull="true" iskey="true">
        <property name="VisibleIndex">2</property>
        <property name="Name">colBank</property>
        <property name="FieldName">Bank</property>
        <property name="GridRow">0</property>
        <property name="Width">70</property>
        <property name="ActualWidth">70</property>
      </property>
      <property name="Item5" isnull="true" iskey="true">
        <property name="VisibleIndex">3</property>
        <property name="Name">colNarrative</property>
        <property name="FieldName">Narrative</property>
        <property name="GridRow">0</property>
        <property name="Width">300</property>
        <property name="ActualWidth">300</property>
      </property>
      <property name="Item6" isnull="true" iskey="true">
        <property name="VisibleIndex">4</property>
        <property name="Name">colValue</property>
        <property name="FieldName">Value</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item7" isnull="true" iskey="true">
        <property name="VisibleIndex">5</property>
        <property name="Name">colPayee</property>
        <property name="FieldName">Payee</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item8" isnull="true" iskey="true">
        <property name="VisibleIndex">6</property>
        <property name="Name">colFeeEarner</property>
        <property name="FieldName">FeeEarner</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item9" isnull="true" iskey="true">
        <property name="VisibleIndex">7</property>
        <property name="Name">colRequestedBy</property>
        <property name="FieldName">RequestedBy</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
    </property>
    <property name="SortInfo" iskey="true" value="0" />
    <property name="View" isnull="true" iskey="true">
      <property name="ShowGroupPanel">false</property>
      <property name="ColumnChooserState" isnull="true" iskey="true">
        <property name="Size">220,250</property>
        <property name="Location">1027,158</property>
      </property>
      <property name="FormatConditions" iskey="true" value="0" />
    </property>
    <property name="GroupSummary" iskey="true" value="0" />
    <property name="TotalSummary" iskey="true" value="0" />
    <property name="MRUFilters" iskey="true" value="1">
      <property name="Item1" isnull="true" iskey="true">
        <property name="FilterText">[Status] = ''Requested''</property>
        <property name="FilterString">[Status] = ''Requested''</property>
      </property>
    </property>
    <property name="FilterString">[Status] = ''Request''</property>
    <property name="IsFilterEnabled">true</property>
    <property name="GroupSummarySortInfo" iskey="true" value="0" />
  </property>
</XtraSerializer>',
       CTQ.[id]
  FROM [dbo].[ControlQueries] CTQ
 WHERE CTQ.[ControlName] = 'gCheques'
   AND CTQ.[OwnerName] = 'MyCheques'
   AND CTQ.[Query] IN ('Requested Cheques', 'Released Cheques', 'Approved Cheques', 'Returned Cheques')

INSERT
  INTO [dbo].[ControlViews]
      ([Handler],
       [View],
       [ControlName],
       [OwnerName],
       [Default],
       [ControlSettings],
       [QueryID])
SELECT CTQ.[HANDLER],
       CTQ.[Query],
       CTQ.[ControlName],
       CTQ.[OwnerName],
       CTQ.[Default],
       '<XtraSerializer version="1.0" application="GridControl">
  <property name="#LayoutVersion" isnull="true" />
  <property name="$GridControl" iskey="true" value="GridControl">
    <property name="GroupCount">0</property>
    <property name="Columns" iskey="true" value="9">
      <property name="Item1" isnull="true" iskey="true">
        <property name="VisibleIndex">0</property>
        <property name="Name">colDate</property>
        <property name="FieldName">RequestDate</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item2" isnull="true" iskey="true">
        <property name="VisibleIndex">2</property>
        <property name="Name">colMatterCode</property>
        <property name="FieldName">MatterCode</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item3" isnull="true" iskey="true">
        <property name="VisibleIndex">1</property>
        <property name="Name">colStatus</property>
        <property name="FieldName">Status</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item4" isnull="true" iskey="true">
        <property name="VisibleIndex">3</property>
        <property name="Name">colBank</property>
        <property name="FieldName">Bank</property>
        <property name="GridRow">0</property>
        <property name="Width">70</property>
        <property name="ActualWidth">70</property>
      </property>
      <property name="Item5" isnull="true" iskey="true">
        <property name="VisibleIndex">4</property>
        <property name="Name">colNarrative</property>
        <property name="FieldName">Narrative</property>
        <property name="GridRow">0</property>
        <property name="Width">300</property>
        <property name="ActualWidth">300</property>
      </property>
      <property name="Item6" isnull="true" iskey="true">
        <property name="VisibleIndex">5</property>
        <property name="Name">colValue</property>
        <property name="FieldName">Value</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item7" isnull="true" iskey="true">
        <property name="VisibleIndex">6</property>
        <property name="Name">colPayee</property>
        <property name="FieldName">Payee</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item8" isnull="true" iskey="true">
        <property name="VisibleIndex">7</property>
        <property name="Name">colFeeEarner</property>
        <property name="FieldName">FeeEarner</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
      <property name="Item9" isnull="true" iskey="true">
        <property name="VisibleIndex">8</property>
        <property name="Name">colRequestedBy</property>
        <property name="FieldName">RequestedBy</property>
        <property name="GridRow">0</property>
        <property name="Width">100</property>
        <property name="ActualWidth">100</property>
      </property>
    </property>
    <property name="SortInfo" iskey="true" value="0" />
    <property name="View" isnull="true" iskey="true">
      <property name="ShowGroupPanel">false</property>
      <property name="ColumnChooserState" isnull="true" iskey="true">
        <property name="Size">220,250</property>
        <property name="Location">1027,158</property>
      </property>
      <property name="FormatConditions" iskey="true" value="0" />
    </property>
    <property name="GroupSummary" iskey="true" value="0" />
    <property name="TotalSummary" iskey="true" value="0" />
    <property name="MRUFilters" iskey="true" value="0" />
    <property name="GroupSummarySortInfo" iskey="true" value="0" />
  </property>
</XtraSerializer>',
       CTQ.[id]
  FROM [dbo].[ControlQueries] CTQ
 WHERE CTQ.[ControlName] = 'gCheques'
   AND CTQ.[OwnerName] = 'MyCheques'
   AND CTQ.[Query] = 'All Cheques'
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.1.63
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.1.83
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 83, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.2.1.83'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
IF NOT EXISTS(SELECT TOP 1 1 FROM Settings WHERE KeyName='AllowToDeleteAction')
BEGIN
	INSERT INTO Settings (KeyName, KeyValue ) VALUES ('AllowToDeleteAction','True')
END
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.1.83
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.1.88
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 88, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.2.1.88'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
DECLARE @MISSINGFILES TABLE
       ([id]         INT            IDENTITY(1, 1),
        [matter]     VARCHAR(20),
        [FILENUM]    INT)

DECLARE @MAXNUM INT

SELECT @MAXNUM = ISNULL(MAX([FILENUM]), 0)
  FROM [dbo].[matters]

SELECT @MAXNUM = CASE WHEN [NEXTFILE] > @MAXNUM
                           THEN [NEXTFILE]
                      ELSE @MAXNUM END
  FROM [dbo].[control]

INSERT
  INTO @MISSINGFILES
      ([matter])
SELECT [code]
  FROM [dbo].[matters]
 WHERE ISNULL([FileNum], 0) = 0

UPDATE MIF
   SET MIF.[FILENUM] = @MAXNUM + MIF.[id]
  FROM @MISSINGFILES MIF

SELECT @MAXNUM = ISNULL(MAX(MIF.[FILENUM]), @MAXNUM)
  FROM @MISSINGFILES MIF

UPDATE MAT
   SET MAT.[FileNum] = MIF.[FILENUM]
  FROM @MISSINGFILES MIF
       INNER JOIN [dbo].[matters] MAT
               ON MAT.[Code] = MIF.[matter]

UPDATE CTL
   SET CTL.[NEXTFILE] = @MAXNUM
  FROM [dbo].[control] CTL
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.1.88
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.1.89
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 89, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.2.1.89'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
INSERT
  INTO [dbo].[DocumentClasses]
      ([CLASSCODE],
       [CLASSDESCRIPTION],
       [Retired])
SELECT DISTINCT 
       TDC.[DOCCLASS],
       'UNKNOWN DOCUMENT CLASS: ' + TDC.[DOCCLASS],
       'N'
  FROM [dbo].[TemplateDocuments] TDC
       LEFT OUTER JOIN [dbo].[DocumentClasses] DCL
                    ON DCL.[CLASSCODE] = TDC.[DOCCLASS]
 WHERE DCL.[CLASSDESCRIPTION] IS NULL
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.1.89
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.1.90
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 90, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.2.1.90'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
IF EXISTS(SELECT TOP 1 1 FROM SYS.objects WHERE OBJECT_NAME(OBJECT_ID) = 'TemplateActions')
BEGIN
	IF NOT EXISTS(SELECT TOP 1 1 FROM TemplateActions WHERE ACTIONCODE = 'TDOC')
	BEGIN
		INSERT INTO 
			TemplateActions 
				([ACTIONCODE],
				[DESC],
				[WKTCODE],
				[ACTTYPE],
				[ACTIONCATEGORY],
				[STATUS],
				[PROCESSTYPE],
				[PUBLISHER],
				[UPDATEFIELD],
				[UPDATEVALUE],
				[HIGHLIGHTED],
				[MILESTONETYPE],
				[PRIORITY],
				[NEXTACTIONOPTIONAL],
				[BILLABLE],
				[EMAIL],
				[BILLDESCRIPTION],
				[AssignActionTo],
				[ASSIGNHANDLER],
				[AssignTeamActionTo],
				[ASSIGNTEAM],
				[ChargeValue],
				[Arrangement],
				[ChargeInterest],
				[Description],
				[AutoPopulate],
				[RequiredAction],
				[AuthorisationRequired],
				[Authby],
				[ConfirmByPW],
				[Flag])
			VALUES
				('TDOC',
				'Process Document Step',
				'SYS',
				'A',
				'A',
				'NA',
				'I',
				'N',
				'N',
				NULL,
				'N',
				NULL,
				'Normal',
				'N',
				'N',
				NULL,
				NULL,
				'L',
				NULL,
				'L',
				NULL,
				0,
				NULL,
				0,
				NULL,
				'N',
				'N',
				'L',
				NULL,
				'N',
				'0')	
	END

END
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.1.90
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.1.91
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 91, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.2.1.91'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
UPDATE Contacts SET OpenMatters = 
(
SELECT 
	COUNT(ClientCode) 
FROM 
	Contacts c
INNER JOIN matters m ON m.ClientCode = c.Code  
WHERE 
	m.Closed <> 'Y' AND 
	c.Code  = contacts.Code
GROUP BY ClientCode 
)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.1.91
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
--Keep this to be safe START
SET NOCOUNT ON
UPDATE #SCRIPT SET [MajorVersion] = 5,
                   [MinorVersion] = 2,
                   [Build] = 2,
                   [Revision] = 1,
                   [CompatibleVersion] = 'Build 5.2.2.1'
SET NOCOUNT OFF
--Keep this to be safe END
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.2.6
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 6, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.2.2.6'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
UPDATE 
	[dbo].[Contacts]
SET 
	[StartDate] = CONVERT(DATETIME, CONVERT(VARCHAR, [StartDate], 112))

GO

UPDATE MAT
   SET MAT.[OrgClosedDate] = CONVERT(DATETIME, CONVERT(VARCHAR, MAT.[OrgClosedDate], 112)),
       MAT.[ReOpenedDate] = CONVERT(DATETIME, CONVERT(VARCHAR, MAT.[ReOpenedDate], 112))
  FROM [dbo].[matters] MAT
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.2.6
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.2.8
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 8, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.2.2.8'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
/****************************************************************************
 Make sure the ATTACHMENTS column is 'Y' for all Email diary entries that
   actually have attachments

 We don't want to lock the entire table and create a gigantic transaction, so
 we do this in batches of 1000 until the job is done.

 Create a table diafixatt for the purpose, this allows us to do the "heavy
 lifting" at the start, keeping the subsequent updates light.
 Table is dropped when the process has completed.

 ****************************************************************************/
IF EXISTS
  (SELECT TOP 1 1
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'diafixatt'
      AND SO.[type] = 'U')
  BEGIN
    DROP TABLE [dbo].[diafixatt]
  END
GO

CREATE TABLE
       [dbo].[diafixatt]
      ([ActionID]      INT,
       [TOTALATT]      INT,
       [TOTALMSG]      INT,
       [DONE]          BIT,
       CONSTRAINT PK_diafixatt PRIMARY KEY CLUSTERED 
                 ([ActionID]))
    ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX
       [IDX_TOTALATT]
    ON [dbo].[diafixatt] 
      ([TOTALATT] ASC,
       [TOTALMSG] ASC)
       INCLUDE ([Actionid])
    ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX
       [IDX_TOTALMSG]
    ON [dbo].[diafixatt] 
      ([TOTALMSG] ASC)
       INCLUDE ([Actionid])
    ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX
       [IDX_DONE]
    ON [dbo].[diafixatt] 
      ([DONE] ASC)
       INCLUDE ([Actionid])
    ON [PRIMARY]
GO

--First, get all Diary Entries that are listed as Emails but that do not
--have ATTACHMENTS = Y set
EXEC ('
  INSERT
    INTO [dbo].[diafixatt]
        ([ActionID],
         [DONE])
  SELECT DIA.[ActionID],
         0
    FROM [dbo].[diary] DIA WITH (NOLOCK)
   WHERE DIA.[ACTIONTYPE] = ''E''
     AND ISNULL(DIA.[ATTACHMENTS], ''N'') <> ''Y''
ORDER BY DIA.[ACTIONID] DESC')
GO

--Count the number of Diary Attachments for these entries...
EXEC ('
UPDATE DIA
   SET DIA.[TOTALATT] = ATT.[TOTAL]
  FROM [dbo].[diafixatt] DIA
       CROSS APPLY (SELECT COUNT(1) AS [TOTAL]
                      FROM [dbo].[DiaryAttachments] DAT WITH (NOLOCK)
                     WHERE DAT.[DiaryID] = DIA.[ActionID]) ATT')
GO

--... those with 1 or less Diary Attachments can at most have the original
--    MSG file, they cannot possibly have attachments. Remove these from
--    the list that is under consideration.
EXEC ('
DELETE DIA
  FROM [dbo].[diafixatt] DIA
 WHERE DIA.[TOTALATT] < 2')
GO

-- Now it gets trickier. 1) If they have at least one Diary Attachment that
-- isn't a .MSG, then they do have attachments
EXEC ('
UPDATE DIA
   SET DIA.[TOTALATT] = ATT.[TOTAL]
  FROM [dbo].[diafixatt] DIA
       CROSS APPLY (SELECT COUNT(1) AS [TOTAL]
                      FROM [dbo].[DiaryAttachments] DAT WITH (NOLOCK)
                     WHERE DAT.[DiaryID] = DIA.[ActionID]
                       AND RTRIM(ISNULL(DAT.[FILEPATH], '''')) NOT LIKE ''%.msg'') ATT')
GO

-- Now it gets trickier. 2) But if they have at least TWO Diary Attachments
-- that are .MSGs then we're dealing with an e-mail that contained another e-mail
-- as an Attachment, so this one should be counted too.
EXEC ('
UPDATE DIA
   SET DIA.[TOTALMSG] = ATT.[TOTAL]
  FROM [dbo].[diafixatt] DIA
       CROSS APPLY (SELECT COUNT(1) AS [TOTAL]
                      FROM [dbo].[DiaryAttachments] DAT WITH (NOLOCK)
                     WHERE DAT.[DiaryID] = DIA.[ActionID]
                       AND RTRIM(ISNULL(DAT.[FILEPATH], '''')) LIKE ''%.msg'') ATT')
GO

-- So we can ignore those that have 1) No Diary Attachments that are NOT .MSGs and
-- 2) only ONE Diary Attachment that IS an MSG
EXEC ('
DELETE DIA
  FROM [dbo].[diafixatt] DIA
 WHERE DIA.[TOTALATT] < 1
   AND DIA.[TOTALMSG] < 2')
GO

-- To avoid creating a single massive transaction we will process the Diary Entries that
-- are identified in [diafixatt] 1000 at a time and wrap each lot of 1000 into a separate
-- transaction. This also means that, should the need arise, this can be interrupted and
-- when it's then re-started at a later stage it won't have to do the whole lot again, but
-- only the ones that hadn't been processed already.
EXEC ('
DECLARE @SIZE INT

SET @SIZE = 1000

DECLARE @DIA TABLE
       ([ActionID] INT)

INSERT
  INTO @DIA
      ([ACTIONID])
  SELECT TOP (@SIZE)
         DIA.[ActionID]
    FROM [dbo].[diafixatt] DIA
   WHERE DIA.[DONE] = 0
ORDER BY DIA.[ActionID] DESC

WHILE EXISTS (SELECT TOP 1 1 FROM @DIA)
  BEGIN

    BEGIN TRANSACTION

    -- Set the ATTACHMENTS field to Y and ...
    UPDATE DIA
       SET DIA.[ATTACHMENTS] = ''Y''
      FROM @DIA UPD
           INNER JOIN [dbo].[diary] DIA
                   ON DIA.[ActionID] = UPD.[ActionID]

    -- Remove the processed rows from [diafixatt]
    DELETE DIA
      FROM @DIA UPD
           INNER JOIN [dbo].[diafixatt] DIA
                   ON DIA.[ActionID] = UPD.[ActionID]

    COMMIT

    --You may want to place a delay here if you are running this
    --interactively while users are using the software.
    --WAITFOR DELAY ''00:00:10''

    DELETE @DIA

      INSERT
        INTO @DIA
            ([ACTIONID])
      SELECT TOP (@SIZE)
             DIA.[ActionID]
        FROM [dbo].[diafixatt] DIA
       WHERE DIA.[DONE] = 0
    ORDER BY DIA.[ActionID] DESC

  END')
GO

-- The processing is complete and the work table can now be deleted.
IF EXISTS
  (SELECT TOP 1 1
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'diafixatt'
      AND SO.[type] = 'U')
  BEGIN
    DROP TABLE [dbo].[diafixatt]
  END
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.2.8
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.2.12
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 12, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.2.2.12'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
INSERT
  INTO [dbo].[FileTypes]
      ([Type],
       [Description],
       [FilePath])
SELECT NW.[Type],
       NW.[Description],
       ''
  FROM (SELECT 'Emi' As [Type],
               'Email' AS [Description]) NW
       LEFT OUTER JOIN [dbo].[FileTypes] OL
                    ON OL.[Type] = NW.[Type]
 WHERE OL.[Type] IS NULL

INSERT
  INTO [dbo].[FileTypes]
      ([Type],
       [Description],
       [FilePath])
SELECT NW.[Type],
       NW.[Description],
       ''
  FROM (SELECT 'MSG' As [Type],
               'Outlook Email' AS [Description]) NW
       LEFT OUTER JOIN [dbo].[FileTypes] OL
                    ON OL.[Type] = NW.[Type]
 WHERE OL.[Type] IS NULL

INSERT
  INTO [dbo].[FileTypes]
      ([Type],
       [Description],
       [FilePath])
SELECT NW.[Type],
       NW.[Description],
       ''
  FROM (SELECT 'DOC' As [Type],
               'Document' AS [Description]) NW
       LEFT OUTER JOIN [dbo].[FileTypes] OL
                    ON OL.[Type] = NW.[Type]
 WHERE OL.[Type] IS NULL

INSERT
  INTO [dbo].[FileTypes]
      ([Type],
       [Description],
       [FilePath])
SELECT NW.[Type],
       NW.[Description],
       ''
  FROM (SELECT 'DOCX' As [Type],
               'Word 2007 Document' AS [Description]) NW
       LEFT OUTER JOIN [dbo].[FileTypes] OL
                    ON OL.[Type] = NW.[Type]
 WHERE OL.[Type] IS NULL

INSERT
  INTO [dbo].[FileTypes]
      ([Type],
       [Description],
       [FilePath])
SELECT NW.[Type],
       NW.[Description],
       ''
  FROM (SELECT 'XLS' As [Type],
               'Excel' AS [Description]) NW
       LEFT OUTER JOIN [dbo].[FileTypes] OL
                    ON OL.[Type] = NW.[Type]
 WHERE OL.[Type] IS NULL

INSERT
  INTO [dbo].[FileTypes]
      ([Type],
       [Description],
       [FilePath])
SELECT NW.[Type],
       NW.[Description],
       ''
  FROM (SELECT 'XLSX' As [Type],
               'Excel 2007 or later' AS [Description]) NW
       LEFT OUTER JOIN [dbo].[FileTypes] OL
                    ON OL.[Type] = NW.[Type]
 WHERE OL.[Type] IS NULL

INSERT
  INTO [dbo].[FileTypes]
      ([Type],
       [Description],
       [FilePath])
SELECT NW.[Type],
       NW.[Description],
       ''
  FROM (SELECT 'PDF' As [Type],
               'PDF' AS [Description]) NW
       LEFT OUTER JOIN [dbo].[FileTypes] OL
                    ON OL.[Type] = NW.[Type]
 WHERE OL.[Type] IS NULL
GO

INSERT
  INTO [dbo].[WorkTypes]
      ([CODE],
       [DESC],
       [RETIRED],
       [ChildCare])
SELECT RTRIM(ISNULL(WTP.[WType], '')),
       'Unknown Worktype: ' + RTRIM(ISNULL(WTP.[WType], '')),
       '',
       'N'
  FROM (SELECT DISTINCT
               MAT.[WType]
          FROM [dbo].[matters] MAT) WTP
       LEFT OUTER JOIN [dbo].[WorkTypes] WT
                    ON WT.[CODE] = WTP.[WType]
 WHERE WT.[CODE] IS NULL
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.2.12
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.2.17
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 17, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.2.2.17'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
IF NOT EXISTS
  (SELECT Top 1 1
     FROM [dbo].[TemplateActions] TAC
    WHERE TAC.[ACTIONCODE] = 'ADMNT')
BEGIN
  INSERT
    INTO [dbo].[TemplateActions]
        ([ACTIONCODE],
         [DESC],
         [WKTCODE],
         [ACTTYPE],
         [ACTIONCATEGORY],
         [STATUS],
         [PROCESSTYPE],
         [PUBLISHER],
         [PRIORITY],
         [NEXTACTIONOPTIONAL],
         [ASSIGNACTIONTO],
         [ASSIGNTEAMACTIONTO],
         [CHARGEVALUE])
  VALUES('ADMNT',
         'Note',
         'SYS',
         'N',
         'N',
         'NA',
         'I',
         'N',
         'Normal',
         'Y',
         'L',
         'L',
         0)
END
GO

IF NOT EXISTS(SELECT TOP 1 1 FROM Settings WHERE Keyname = 'DoLicenseValidation')
BEGIN
	INSERT INTO Settings 
	(Keyname, KeyValue ) values('DoLicenseValidation','False')
END
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.2.17
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.2.23
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 23, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.2.2.23'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
IF NOT EXISTS(SELECT TOP 1 1 FROM Settings WHERE KeyName='AllowToDeleteAction')
BEGIN
	INSERT INTO Settings (KeyName, KeyValue ) VALUES ('AllowToDeleteAction','True')
END
ELSE
BEGIN
	UPDATE Settings set KeyValue = 'True' WHERE KeyName='AllowToDeleteAction'
END
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.2.23
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.2.25
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 25, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.2.2.25'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
IF EXISTS
  (SELECT TOP 1 1
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'BillHeader'
      AND SO.[type] = 'U')
  BEGIN
    EXEC ('
    UPDATE BH
       SET BH.[FeCode] = CASE WHEN RTRIM(ISNULL(BH.[FeCode], '''')) <> ''''
                                   THEN BH.[FeCode]
                              WHEN [dbo].[ky_NETFNMatterFECode](BH.[MATTER]) <> ''''
                                   THEN [dbo].[ky_NETFNMatterFECode](BH.[MATTER])
                              ELSE RTRIM(ISNULL(HAN.[CODE], ISNULL(HAN2.[CODE], ISNULL(HAN3.[CODE], ''ADM'')))) END
      FROM [dbo].[BillHeader] BH
           LEFT OUTER JOIN [dbo].[Handlers] HAN
                        ON HAN.[CODE] = BH.[USER]
           LEFT OUTER JOIN [dbo].[Handlers] HAN2
                        ON HAN2.[LOGON] = BH.[USER]
           LEFT OUTER JOIN [dbo].[Handlers] HAN3
                        ON HAN3.[LOGON] LIKE BH.[USER] + ''%''')
  END
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.2.25
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.2.26
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 26, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.2.2.26'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
INSERT
  INTO [dbo].[AlarmStatus]
      ([StatusID],
       [Description])
SELECT NWS.[StatusID],
       NWS.[Description]
  FROM (SELECT 1 AS [StatusID],
               'Active' As [Description]) NWS
       LEFT OUTER JOIN [dbo].[AlarmStatus] ALS
                    ON ALS.[StatusID] = NWS.[StatusID]
 WHERE ALS.[StatusID] IS NULL
GO

INSERT
  INTO [dbo].[AlarmStatus]
      ([StatusID],
       [Description])
SELECT NWS.[StatusID],
       NWS.[Description]
  FROM (SELECT 2 AS [StatusID],
               'Actioned' As [Description]) NWS
       LEFT OUTER JOIN [dbo].[AlarmStatus] ALS
                    ON ALS.[StatusID] = NWS.[StatusID]
 WHERE ALS.[StatusID] IS NULL
GO

INSERT
  INTO [dbo].[AlarmStatus]
      ([StatusID],
       [Description])
SELECT NWS.[StatusID],
       NWS.[Description]
  FROM (SELECT 3 AS [StatusID],
               'Disabled' As [Description]) NWS
       LEFT OUTER JOIN [dbo].[AlarmStatus] ALS
                    ON ALS.[StatusID] = NWS.[StatusID]
 WHERE ALS.[StatusID] IS NULL
GO

INSERT
  INTO [dbo].[AlarmStatus]
      ([StatusID],
       [Description])
SELECT NWS.[StatusID],
       NWS.[Description]
  FROM (SELECT 4 AS [StatusID],
               'On hold' As [Description]) NWS
       LEFT OUTER JOIN [dbo].[AlarmStatus] ALS
                    ON ALS.[StatusID] = NWS.[StatusID]
 WHERE ALS.[StatusID] IS NULL
GO

INSERT
  INTO [dbo].[AlarmStatus]
      ([StatusID],
       [Description])
SELECT NWS.[StatusID],
       NWS.[Description]
  FROM (SELECT 5 AS [StatusID],
               'Attention' As [Description]) NWS
       LEFT OUTER JOIN [dbo].[AlarmStatus] ALS
                    ON ALS.[StatusID] = NWS.[StatusID]
 WHERE ALS.[StatusID] IS NULL
GO

INSERT
  INTO [dbo].[AlarmTypes]
      ([TypeID],
       [Description])
SELECT NWT.[TypeID],
       NWT.[Description]
  FROM (SELECT 1 AS [TypeID],
               'Generic Alarm' As [Description]) NWT
       LEFT OUTER JOIN [dbo].[AlarmTypes] ALT
                    ON ALT.[TypeID] = NWT.[TypeID]
 WHERE ALT.[TypeID] IS NULL
GO

INSERT
  INTO [dbo].[AlarmTypes]
      ([TypeID],
       [Description])
SELECT NWT.[TypeID],
       NWT.[Description]
  FROM (SELECT 2 AS [TypeID],
               'Case Related' As [Description]) NWT
       LEFT OUTER JOIN [dbo].[AlarmTypes] ALT
                    ON ALT.[TypeID] = NWT.[TypeID]
 WHERE ALT.[TypeID] IS NULL
GO

INSERT
  INTO [dbo].[AlarmTypes]
      ([TypeID],
       [Description])
SELECT NWT.[TypeID],
       NWT.[Description]
  FROM (SELECT 3 AS [TypeID],
               'Action' As [Description]) NWT
       LEFT OUTER JOIN [dbo].[AlarmTypes] ALT
                    ON ALT.[TypeID] = NWT.[TypeID]
 WHERE ALT.[TypeID] IS NULL
GO

INSERT
  INTO [dbo].[AlarmTypes]
      ([TypeID],
       [Description])
SELECT NWT.[TypeID],
       NWT.[Description]
  FROM (SELECT 4 AS [TypeID],
               'Performance' As [Description]) NWT
       LEFT OUTER JOIN [dbo].[AlarmTypes] ALT
                    ON ALT.[TypeID] = NWT.[TypeID]
 WHERE ALT.[TypeID] IS NULL
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.2.26
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.2.34
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 34, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.2.2.34'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
IF EXISTS
  (SELECT TOP 1 1
     FROM [dbo].[PerformanceAlarmStatements] PAS
    WHERE PAS.[PACode] = 'KYLRA')
  BEGIN
    UPDATE PAS
       SET PAS.[PATotal] = 'SELECT COUNT(1) AS [TOTAL]
  FROM [dbo].[diary] DIA
       INNER JOIN [dbo].[Matters] MAT
                  INNER JOIN [dbo].[Contacts] CON
                          ON [CON].[CODE] = MAT.[ClientCode]
               ON MAT.[Code] = DIA.[CaseCode]
              AND MAT.[Closed] = ''N''
       INNER JOIN [dbo].[TemplateActions] TAC
               ON TAC.[ACTIONCODE] = DIA.[ACTIONCODE]
              AND TAC.[RequiredAction] = ''Y''
 WHERE DIA.[STATUS] = 0
   AND DATEDIFF(day, DIA.[DUEDATE], GetDate()) > 0',
           PAS.[PADetail] = 'select DIA.[CaseCode] As [AlarmMatter],
       DIA.[ActionID] As [AlarmActionID],
       [dbo].[ky_ConvertDateAndClarionTimeToDateTime](IsNull(DEL.[DATE], DIA.[DATE]), IsNull(DEL.[TIME], DIA.[DYSTARTTIME])) As [AlarmDate],
       DIA.[DUEDATE] As [AlarmDueDate],
       [dbo].[ky_RemoveSpuriousWhitespace2](DIA.[TEXT1], 500) [AlarmText],
       [dbo].[ky_RemoveSpuriousWhitespace2](DIA.[TEXT2], 500) [AlarmText2],
       [dbo].[ky_RemoveSpuriousWhitespace2](DIA.[SUBJECT], 500) [AlarmSubject],
       RTrim(IsNull(CON.[Code], '''')) As [ClientCode],
       RTrim(IsNull(CON.[Name], '''')) As [ClientName],
       RTrim(IsNull(MAT.[Matter], '''')) As [MatterCode],
       RTrim(IsNull(MAT.[Description], '''')) As [MatterName],
       RTrim(IsNull(MAT.[Code], '''')) + '' - '' + RTrim(IsNull(CON.[Name], '''')) + '' / '' + RTrim(IsNull(MAT.[Description], '''')) As [MatterDescription],
       RTrim(IsNull(DEL.[Handler], IsNull(DIA.[FNCODE], ''''))) As [AlarmHandler],
       RTrim(IsNull(DEL.[Name], IsNull(HANA.[Name], ''''))) As [AlarmHandlerName]
  FROM [dbo].[diary] DIA
       INNER JOIN [dbo].[Matters] MAT
                  INNER JOIN [dbo].[Contacts] CON
                          ON [CON].[CODE] = MAT.[ClientCode]
               ON MAT.[Code] = DIA.[CaseCode]
              AND MAT.[Closed] = ''N''
       INNER JOIN [dbo].[TemplateActions] TAC
               ON TAC.[ACTIONCODE] = DIA.[ACTIONCODE]
              AND TAC.[RequiredAction] = ''Y''
       OUTER APPLY (  SELECT TOP 1 
                             DLG.[DATE],
                             DLG.[TIME],
                             DLG.[Handler],
                             HAND.[NAME]
                        FROM [dbo].[DiaryDelegations] DLG
                             INNER JOIN [dbo].[Handlers] HAND
                                     ON HAND.[Code] = DLG.[Handler]
                       WHERE DLG.[ACTIONID] = DIA.[ACTIONID]
                         AND DLG.[STATUS] = 0
                    ORDER BY DLG.[AssignNo] DESC) DEL
       LEFT OUTER JOIN [dbo].[Handlers] HANA
                    ON HANA.[Code] = DIA.[FNCODE]
 WHERE DIA.[STATUS] = 0
   AND DATEDIFF(day, DIA.[DUEDATE], GetDate()) > 0',
           PAS.[PAVersion] = '5.2.2.34'
      FROM [dbo].[PerformanceAlarmStatements] PAS
     WHERE PAS.[PACode] = 'KYLRA'
  END
ELSE
  BEGIN
    INSERT
      INTO [dbo].[PerformanceAlarmStatements]
          ([ID],
           [PAName],
           [PACode],
           [PATotal],
           [PADetail],
           [PAVersion])
    VALUES(1,
           'Lapsed Required Actions',
           'KYLRA',
           'SELECT COUNT(1) AS [TOTAL]
  FROM [dbo].[diary] DIA
       INNER JOIN [dbo].[Matters] MAT
                  INNER JOIN [dbo].[Contacts] CON
                          ON [CON].[CODE] = MAT.[ClientCode]
               ON MAT.[Code] = DIA.[CaseCode]
              AND MAT.[Closed] = ''N''
       INNER JOIN [dbo].[TemplateActions] TAC
               ON TAC.[ACTIONCODE] = DIA.[ACTIONCODE]
              AND TAC.[RequiredAction] = ''Y''
 WHERE DIA.[STATUS] = 0
   AND DATEDIFF(day, DIA.[DUEDATE], GetDate()) > 0',
           'select DIA.[CaseCode] As [AlarmMatter],
       DIA.[ActionID] As [AlarmActionID],
       [dbo].[ky_ConvertDateAndClarionTimeToDateTime](IsNull(DEL.[DATE], DIA.[DATE]), IsNull(DEL.[TIME], DIA.[DYSTARTTIME])) As [AlarmDate],
       DIA.[DUEDATE] As [AlarmDueDate],
       [dbo].[ky_RemoveSpuriousWhitespace2](DIA.[TEXT1], 500) [AlarmText],
       [dbo].[ky_RemoveSpuriousWhitespace2](DIA.[TEXT2], 500) [AlarmText2],
       [dbo].[ky_RemoveSpuriousWhitespace2](DIA.[SUBJECT], 500) [AlarmSubject],
       RTrim(IsNull(CON.[Code], '''')) As [ClientCode],
       RTrim(IsNull(CON.[Name], '''')) As [ClientName],
       RTrim(IsNull(MAT.[Matter], '''')) As [MatterCode],
       RTrim(IsNull(MAT.[Description], '''')) As [MatterName],
       RTrim(IsNull(MAT.[Code], '''')) + '' - '' + RTrim(IsNull(CON.[Name], '''')) + '' / '' + RTrim(IsNull(MAT.[Description], '''')) As [MatterDescription],
       RTrim(IsNull(DEL.[Handler], IsNull(DIA.[FNCODE], ''''))) As [AlarmHandler],
       RTrim(IsNull(DEL.[Name], IsNull(HANA.[Name], ''''))) As [AlarmHandlerName]
  FROM [dbo].[diary] DIA
       INNER JOIN [dbo].[Matters] MAT
                  INNER JOIN [dbo].[Contacts] CON
                          ON [CON].[CODE] = MAT.[ClientCode]
               ON MAT.[Code] = DIA.[CaseCode]
              AND MAT.[Closed] = ''N''
       INNER JOIN [dbo].[TemplateActions] TAC
               ON TAC.[ACTIONCODE] = DIA.[ACTIONCODE]
              AND TAC.[RequiredAction] = ''Y''
       OUTER APPLY (  SELECT TOP 1 
                             DLG.[DATE],
                             DLG.[TIME],
                             DLG.[Handler],
                             HAND.[NAME]
                        FROM [dbo].[DiaryDelegations] DLG
                             INNER JOIN [dbo].[Handlers] HAND
                                     ON HAND.[Code] = DLG.[Handler]
                       WHERE DLG.[ACTIONID] = DIA.[ACTIONID]
                         AND DLG.[STATUS] = 0
                    ORDER BY DLG.[AssignNo] DESC) DEL
       LEFT OUTER JOIN [dbo].[Handlers] HANA
                    ON HANA.[Code] = DIA.[FNCODE]
 WHERE DIA.[STATUS] = 0
   AND DATEDIFF(day, DIA.[DUEDATE], GetDate()) > 0',
           '5.2.2.34')
  END
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.2.34
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.2.58
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 58, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.2.2.58'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
IF NOT EXISTS(SELECT TOP 1 1 FROM Settings WHERE KeyName='NewCaseWizardBranch')
BEGIN
 INSERT INTO Settings (KeyName, KeyValue ) VALUES ('NewCaseWizardBranch','False')
END
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.2.58
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.2.59
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 59, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.2.2.59'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
 --To update all retired field empty if its null for all existing case associates,
 --for new case associates we handled in sp to insert empty string
UPDATE CaseAssociatesContacts SET Retired='' WHERE Retired is null
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.2.59
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.2.60
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 60, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.2.2.60'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
EXEC [dbo].[ky_NETSetSettings] 'SupportEmailAddress', 'support@keyhouse.assist.com'
GO
EXEC [dbo].[ky_NETSetSettings] 'SalesEmailAddress', 'sales@keyhouse.ie'
GO
EXEC [dbo].[ky_NETSetSettings] 'AdminEmailAddress', 'admin@keyhouse.ie'
GO
EXEC [dbo].[ky_NETSetSettings] 'InfoEmailAddress', 'info@keyhouse.ie'
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.2.60
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.2.64
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 64, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.2.2.64'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
IF NOT EXISTS(SELECT TOP 1 1 FROM Settings WHERE KeyName='EstimateDateMaxLimit')
BEGIN
	INSERT INTO Settings (KeyName, KeyValue ) VALUES ('EstimateDateMaxLimit','18')
END
GO

--Estimate Fee required at matter setup
IF NOT EXISTS(SELECT TOP 1 1 FROM Settings WHERE KeyName='ExpInvoiceDateRequiredAtMatterSetup')
BEGIN
	INSERT INTO Settings (KeyName, KeyValue ) VALUES ('ExpInvoiceDateRequiredAtMatterSetup','False')
END

GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.2.64
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.2.65
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 65, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.2.2.65'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
IF NOT EXISTS(SELECT TOP 1 1 FROM Settings WHERE KeyName='LeaveDocumentsOpenOnGenerate')
BEGIN
	INSERT INTO Settings (KeyName, KeyValue ) VALUES ('LeaveDocumentsOpenOnGenerate','False')
END
GO

INSERT
  INTO [dbo].[ActionWorkTypes]
      ([WORKTYPE],
       [ACTIONCODE],
       [SEQ])
SELECT TA.[WKTCODE],
       TA.[ACTIONCODE],
       NA.[NEWSEQ]
  FROM [dbo].[TemplateActions] TA
       CROSS APPLY (SELECT ISNULL(MAX(AWT.[SEQ]), 0) + 1 AS [NEWSEQ]
                      FROM [dbo].[ActionWorkTypes] AWT
                     WHERE AWT.[WORKTYPE] = TA.[WKTCODE]) NA
       LEFT OUTER JOIN [dbo].[ActionWorkTypes] EWT
                    ON EWT.[WORKTYPE] = TA.[WKTCODE]
                   AND EWT.[ACTIONCODE] = TA.[ACTIONCODE]
 WHERE TA.[ACTIONCODE] = 'ADMKD'
   AND EWT.[ACTIONCODE] IS NULL
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.2.65
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.2.67
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 67, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.2.2.67'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
IF NOT EXISTS
  (SELECT TOP 1 1
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'SystemUserDefinedFieldsBackupB52267'
      AND SO.[type] = 'U')
  BEGIN
    EXEC ('    SELECT *
      INTO [dbo].[SystemUserDefinedFieldsBackupB52267]
      FROM [dbo].[SystemUserDefinedFields]')
  END
GO

--Correct some obvious mistakes observed in various databases
UPDATE SUF
   SET SUF.[ACTUALNAME] = 'NAM:DECEASEDDATE'
  FROM [dbo].[SystemUserDefinedFields] SUF
 WHERE SUF.[ACTUALNAME] = 'NAM:DOD'

UPDATE SUF
   SET SUF.[ACTUALNAME] = 'NAM:SSNUMBER'
  FROM [dbo].[SystemUserDefinedFields] SUF
 WHERE SUF.[ACTUALNAME] = 'NAM:SSINumber'

UPDATE SUF
   SET SUF.[ACTUALNAME] = 'NAM:DATESEPARATED'
  FROM [dbo].[SystemUserDefinedFields] SUF
 WHERE SUF.[ACTUALNAME] = 'NAM:DateDeparated'

UPDATE SUF
   SET SUF.[ACTUALNAME] = 'CNT:RSINo'
  FROM [dbo].[SystemUserDefinedFields] SUF
 WHERE SUF.[ACTUALNAME] = '(CNT:RSINo)'

UPDATE SUF
   SET SUF.[ACTUALNAME] = 'LinearAddress(LCL:CLLegalAddr)'
  FROM [dbo].[SystemUserDefinedFields] SUF
 WHERE SUF.[ACTUALNAME] = 'LinearAddress(LCL:CLegalAddr)'

UPDATE SUF
   SET SUF.[ACTUALNAME] = 'LCN:Occupation'
  FROM [dbo].[SystemUserDefinedFields] SUF
 WHERE SUF.[FILEPREFIX] = 'LCN:'
   AND SUF.[FieldName] = 'Occcupation'
   AND ISNULL(SUF.[ACTUALNAME], '') = ''

UPDATE SUF
   SET SUF.[ACTUALNAME] = 'LCL:ClClientYN'
  FROM [dbo].[SystemUserDefinedFields] SUF
 WHERE SUF.[FILEPREFIX] = 'LCL:'
   AND SUF.[FieldName] = 'CLClient YN'
   AND ISNULL(SUF.[ACTUALNAME], '') = ''

UPDATE SUF
   SET SUF.[ACTUALNAME] = 'LCL:CLType'
  FROM [dbo].[SystemUserDefinedFields] SUF
 WHERE SUF.[FILEPREFIX] = 'LCL:'
   AND SUF.[FieldName] = 'ClTyp'
   AND ISNULL(SUF.[ACTUALNAME], '') = ''

UPDATE SUF
   SET SUF.[ACTUALNAME] = 'CSM:CSCLBENYN'
  FROM [dbo].[SystemUserDefinedFields] SUF
 WHERE SUF.[FILEPREFIX] = 'CSM:'
   AND SUF.[FieldName] = 'CSCIBenYN'
   AND ISNULL(SUF.[ACTUALNAME], '') = ''

UPDATE SUF
   SET SUF.[ACTUALNAME] = 'CSM:CSCLEXEYN'
  FROM [dbo].[SystemUserDefinedFields] SUF
 WHERE SUF.[FILEPREFIX] = 'CSM:'
   AND SUF.[FieldName] = 'CSCIExeYN'
   AND ISNULL(SUF.[ACTUALNAME], '') = ''

UPDATE SUF
   SET SUF.[ACTUALNAME] = 'CSM:CSIRTCODE'
  FROM [dbo].[SystemUserDefinedFields] SUF
 WHERE SUF.[FILEPREFIX] = 'CSM:'
   AND SUF.[FieldName] = 'CslrtCode'
   AND ISNULL(SUF.[ACTUALNAME], '') = ''

UPDATE SUF
   SET SUF.[FORMAT] = '@s' + CONVERT(VARCHAR(3), COL.[SystemSize])
  FROM [dbo].[SystemUserDefinedFields] SUF
       OUTER APPLY (SELECT SC.[name] AS [SystemField],
                           ST.[name] AS [SystemType],
                           CASE WHEN SC.[Precision] > 0 THEN SC.[Precision] ELSE SC.[max_length] END AS [SystemSize],
                           SC.[scale] AS [SystemDecimals]
                      FROM SYS.[objects] SO
                           INNER JOIN SYS.[columns] SC
                                      INNER JOIN SYS.[types] ST
                                              ON ST.[system_type_id] = SC.[system_type_id]
                                   ON SC.[object_id] = SO.[object_id]
                                  AND (   SC.[name] = SUF.[FIELDNAME]
                                       OR SC.[name] = SUF.[FIELDNAME] + '_DATE')
                     WHERE SO.[name] = [dbo].[ky_NETFNSystemTable](SUF.[FILEPREFIX])
                       AND SO.[type] = 'U') COL
 WHERE (   ISNUMERIC(SUF.[FORMAT]) = 1
        OR ISNULL(SUF.[FORMAT], '') = '')
   AND SUF.[FILEPREFIX] = 'CSM:'
   AND COL.[SystemType] IN ('char', 'varchar')
   AND COL.[SystemField] IS NOT NULL

UPDATE SUF
   SET SUF.[FORMAT] = '@n' + CONVERT(VARCHAR(3), COL.[SystemSize])
  FROM [dbo].[SystemUserDefinedFields] SUF
       OUTER APPLY (SELECT SC.[name] AS [SystemField],
                           ST.[name] AS [SystemType],
                           CASE WHEN SC.[Precision] > 0 THEN SC.[Precision] ELSE SC.[max_length] END AS [SystemSize],
                           SC.[scale] AS [SystemDecimals]
                      FROM SYS.[objects] SO
                           INNER JOIN SYS.[columns] SC
                                      INNER JOIN SYS.[types] ST
                                              ON ST.[system_type_id] = SC.[system_type_id]
                                   ON SC.[object_id] = SO.[object_id]
                                  AND (   SC.[name] = SUF.[FIELDNAME]
                                       OR SC.[name] = SUF.[FIELDNAME] + '_DATE')
                     WHERE SO.[name] = [dbo].[ky_NETFNSystemTable](SUF.[FILEPREFIX])
                       AND SO.[type] = 'U') COL
 WHERE (   ISNUMERIC(SUF.[FORMAT]) = 1
        OR ISNULL(SUF.[FORMAT], '') = '')
   AND SUF.[FILEPREFIX] = 'CSM:'
   AND COL.[SystemType] IN ('int', 'smallint')
   AND COL.[SystemField] IS NOT NULL

UPDATE SUF
   SET SUF.[FORMAT] = '@n' + CONVERT(VARCHAR(3), COL.[SystemSize]) + '.' + CONVERT(VARCHAR(3), COL.[SystemDecimals])
  FROM [dbo].[SystemUserDefinedFields] SUF
       OUTER APPLY (SELECT SC.[name] AS [SystemField],
                           ST.[name] AS [SystemType],
                           CASE WHEN SC.[Precision] > 0 THEN SC.[Precision] ELSE SC.[max_length] END AS [SystemSize],
                           SC.[scale] AS [SystemDecimals]
                      FROM SYS.[objects] SO
                           INNER JOIN SYS.[columns] SC
                                      INNER JOIN SYS.[types] ST
                                              ON ST.[system_type_id] = SC.[system_type_id]
                                   ON SC.[object_id] = SO.[object_id]
                                  AND (   SC.[name] = SUF.[FIELDNAME]
                                       OR SC.[name] = SUF.[FIELDNAME] + '_DATE')
                     WHERE SO.[name] = [dbo].[ky_NETFNSystemTable](SUF.[FILEPREFIX])
                       AND SO.[type] = 'U') COL
 WHERE (   ISNUMERIC(SUF.[FORMAT]) = 1
        OR ISNULL(SUF.[FORMAT], '') = '')
   AND SUF.[FILEPREFIX] = 'CSM:'
   AND COL.[SystemType] = 'decimal'
   AND COL.[SystemField] IS NOT NULL

UPDATE SUF
   SET SUF.[FORMAT] = '@d6'
  FROM [dbo].[SystemUserDefinedFields] SUF
       OUTER APPLY (SELECT SC.[name] AS [SystemField],
                           ST.[name] AS [SystemType],
                           CASE WHEN SC.[Precision] > 0 THEN SC.[Precision] ELSE SC.[max_length] END AS [SystemSize],
                           SC.[scale] AS [SystemDecimals]
                      FROM SYS.[objects] SO
                           INNER JOIN SYS.[columns] SC
                                      INNER JOIN SYS.[types] ST
                                              ON ST.[system_type_id] = SC.[system_type_id]
                                   ON SC.[object_id] = SO.[object_id]
                                  AND (   SC.[name] = SUF.[FIELDNAME]
                                       OR SC.[name] = SUF.[FIELDNAME] + '_DATE')
                     WHERE SO.[name] = [dbo].[ky_NETFNSystemTable](SUF.[FILEPREFIX])
                       AND SO.[type] = 'U') COL
 WHERE (   ISNUMERIC(SUF.[FORMAT]) = 1
        OR ISNULL(SUF.[FORMAT], '') = '')
   AND SUF.[FILEPREFIX] = 'CSM:'
   AND COL.[SystemType] = 'datetime'
   AND COL.[SystemField] IS NOT NULL

UPDATE SUF
   SET SUF.[FORMAT] = '@s' + CONVERT(VARCHAR(10), SC.[max_length])
  FROM [dbo].[SystemUserDefinedFields] SUF
       INNER JOIN SYS.[objects] SO
               ON SO.[name] = 'CaseMaster'
       INNER JOIN SYS.[columns] SC
                  INNER JOIN SYS.[types] ST
                          ON ST.[system_type_id] = SC.[system_type_id]
               ON SC.[object_id] = SO.[object_id]
              AND 'CSM:' + SC.[name] = SUF.[ACTUALNAME]
 WHERE SUF.[FILEPREFIX] = 'CSM:'
   AND ISNUMERIC(SUF.[FORMAT]) = 1
   AND ST.[name] IN ('char', 'varchar')

UPDATE SUF
   SET SUF.[FORMAT] = '@s' + CONVERT(VARCHAR(3), COL.[systemsize])
  FROM [dbo].[SystemUserDefinedFields] SUF
       OUTER APPLY (SELECT SC.[name] AS [SystemField],
                           ST.[name] AS [SystemType],
                           CASE WHEN SC.[Precision] > 0 THEN SC.[Precision] ELSE SC.[max_length] END AS [SystemSize],
                           SC.[scale] AS [SystemDecimals]
                      FROM SYS.[objects] SO
                           INNER JOIN SYS.[columns] SC
                                      INNER JOIN SYS.[types] ST
                                              ON ST.[system_type_id] = SC.[system_type_id]
                                   ON SC.[object_id] = SO.[object_id]
                                  AND SC.[name] = SUF.[FIELDNAME]
                     WHERE SO.[name] = 'DebtCostingLedger') COL
 WHERE (   ISNUMERIC(SUF.[FORMAT]) = 1
        OR ISNULL(SUF.[FORMAT], '') = '')
   AND COL.[SystemField] IS NOT NULL

UPDATE SUF
   SET SUF.[FORMAT] = '@s' + CONVERT(VARCHAR(3), COL.[systemsize])
  FROM [dbo].[SystemUserDefinedFields] SUF
       OUTER APPLY (SELECT SC.[name] AS [SystemField],
                           ST.[name] AS [SystemType],
                           CASE WHEN SC.[Precision] > 0 THEN SC.[Precision] ELSE SC.[max_length] END AS [SystemSize],
                           SC.[scale] AS [SystemDecimals]
                      FROM SYS.[objects] SO
                           INNER JOIN SYS.[columns] SC
                                      INNER JOIN SYS.[types] ST
                                              ON ST.[system_type_id] = SC.[system_type_id]
                                   ON SC.[object_id] = SO.[object_id]
                                  AND 'DEA:' + SC.[name] = SUF.[ACTUALNAME]
                     WHERE SO.[name] = 'DebtCostingLedger') COL
 WHERE (   ISNUMERIC(SUF.[FORMAT]) = 1
        OR ISNULL(SUF.[FORMAT], '') = '')
   AND COL.[SystemField] IS NOT NULL

UPDATE SUF
   SET SUF.[ACTUALNAME] = 'today()'
  FROM [dbo].[SystemUserDefinedFields] SUF
 WHERE SUF.[FILEPREFIX] = 'DATE:'
   AND SUF.[FieldName] = 'Date'
   AND ISNULL(SUF.[ACTUALNAME], '') = ''

UPDATE SUF
   SET SUF.[LENGTH] = COL.[SystemSize],
       SUF.[FORMAT] = '@s' + CONVERT(VARCHAR(10), COL.[SystemSize])
  FROM [dbo].[SystemUserDefinedFields] SUF
       OUTER APPLY (SELECT SC.[name] AS [SystemField],
                           ST.[name] AS [SystemType],
                           CASE WHEN SC.[Precision] > 0 THEN SC.[Precision] ELSE SC.[max_length] END AS [SystemSize],
                           SC.[scale] AS [SystemDecimals]
                      FROM SYS.[objects] SO
                           INNER JOIN SYS.[columns] SC
                                      INNER JOIN SYS.[types] ST
                                              ON ST.[system_type_id] = SC.[system_type_id]
                                   ON SC.[object_id] = SO.[object_id]
                                  AND 1 = CASE WHEN SC.[name] = SUF.[FIELDNAME]
                                                    THEN 1
                                               WHEN SC.[name] = SUF.[FIELDNAME] + '_DATE'
                                                    THEN 1
                                               WHEN CHARINDEX(':', SUF.[ACTUALNAME], 1) = 0
                                                    THEN 0
                                               WHEN SC.[name] = SUBSTRING(SUF.[ActualName], CHARINDEX(':', SUF.[ACTUALNAME], 1) + 1, LEN(SUF.[ACTUALNAME]) - CHARINDEX(':', SUF.[ACTUALNAME], 1))
                                                    THEN 1
                                               ELSE 0 END
                     WHERE SO.[name] = [dbo].[ky_NETFNSystemTable](SUF.[FILEPREFIX])
                       AND SO.[type] = 'U') COL
 WHERE ISNUMERIC(SUF.[FORMAT]) = 0
   AND SUF.[FORMAT] <> ''
   AND SUF.[FILEPREFIX] <> 'UDF:'
   AND COL.[SystemField] IS NOT NULL
   AND ISNULL(SUF.[ACTUALNAME], '') = ''
   AND COL.[SystemType] IN ('char', 'varchar')
   AND (   1 = CASE WHEN SUF.[FORMAT] NOT LIKE '@s%'
                        THEN 1
                   WHEN CONVERT(INT, REPLACE(SUF.[FORMAT], '@s', '')) < COL.[SystemSize]
                        THEN 1
                   ELSE 0 END
        OR SUF.[LENGTH] < COL.[SystemSize])

UPDATE SUF
   SET SUF.[FORMAT] = '@n' + CASE WHEN COL.[SystemType] IN ('int', 'smallint')
                                       THEN CONVERT(VARCHAR(3), SUF.[LENGTH])
                                  ELSE CONVERT(VARCHAR(3), COL.[systemsize]) + '.' + CONVERT(VARCHAR(3), COL.[SystemDecimals]) END,
       SUF.[LENGTH] = CASE WHEN COL.[SystemType] IN ('int', 'smallint')
                                THEN SUF.[LENGTH] -- do not touch!
                           ELSE COL.[SystemSize] END,
       SUF.[DECMIAL] = CASE WHEN COL.[SystemType] IN ('int', 'smallint')
                                 THEN 0
                            ELSE COL.[SystemDecimals] END
  FROM [dbo].[SystemUserDefinedFields] SUF
       OUTER APPLY (SELECT SC.[name] AS [SystemField],
                           ST.[name] AS [SystemType],
                           CASE WHEN SC.[Precision] > 0 THEN SC.[Precision] ELSE SC.[max_length] END AS [SystemSize],
                           SC.[scale] AS [SystemDecimals]
                      FROM SYS.[objects] SO
                           INNER JOIN SYS.[columns] SC
                                      INNER JOIN SYS.[types] ST
                                              ON ST.[system_type_id] = SC.[system_type_id]
                                   ON SC.[object_id] = SO.[object_id]
                                  AND 1 = CASE WHEN SC.[name] = SUF.[FIELDNAME]
                                                    THEN 1
                                               WHEN SC.[name] = SUF.[FIELDNAME] + '_DATE'
                                                    THEN 1
                                               WHEN CHARINDEX(':', SUF.[ACTUALNAME], 1) = 0
                                                    THEN 0
                                               WHEN SC.[name] = SUBSTRING(SUF.[ActualName], CHARINDEX(':', SUF.[ACTUALNAME], 1) + 1, LEN(SUF.[ACTUALNAME]) - CHARINDEX(':', SUF.[ACTUALNAME], 1))
                                                    THEN 1
                                               ELSE 0 END
                     WHERE SO.[name] = [dbo].[ky_NETFNSystemTable](SUF.[FILEPREFIX])
                       AND SO.[type] = 'U') COL
 WHERE ISNUMERIC(SUF.[FORMAT]) = 0
   AND SUF.[FORMAT] <> ''
   AND SUF.[FILEPREFIX] <> 'UDF:'
   AND COL.[SystemField] IS NOT NULL
   AND ISNULL(SUF.[ACTUALNAME], '') = ''
   AND COL.[SystemType] NOT IN ('char', 'varchar', 'datetime')
   AND (   (    COL.SystemType = 'decimal'
            AND 1 = CASE WHEN SUF.[FORMAT] NOT LIKE '@n%'
                         THEN 1
                    WHEN CHARINDEX('.', SUF.[Format], 1) = 0
                         THEN CASE WHEN CONVERT(INT, REPLACE(SUF.[Format], '@n', '')) < COL.[SystemSize]
                                        THEN 1
                                   ELSE 0 END
                    WHEN CONVERT(INT, SUBSTRING(SUF.[Format], 3, CHARINDEX('.', SUF.[Format], 1) - 3)) < COL.[SystemSize]
                         THEN 1
                    ELSE 0 END)
        OR (    COL.SystemType = 'smallint'
            AND 1 = CASE WHEN SUF.[FORMAT] NOT LIKE '@n%'
                         THEN 1
                    WHEN CHARINDEX('.', SUF.[Format], 1) = 0
                         THEN CASE WHEN CONVERT(INT, REPLACE(SUF.[Format], '@n', '')) < SUF.[LENGTH]
                                        THEN 1
                                   ELSE 0 END
                    ELSE 1 END)
        OR (    COL.SystemType = 'int'
            AND 1 = CASE WHEN SUF.[FORMAT] NOT LIKE '@n%'
                         THEN 1
                    WHEN CHARINDEX('.', SUF.[Format], 1) = 0
                         THEN CASE WHEN CONVERT(INT, REPLACE(SUF.[Format], '@n', '')) < SUF.[LENGTH]
                                        THEN 1
                                   ELSE 0 END
                    ELSE 1 END)
        OR (    COL.[SystemType] = 'decimal'
            AND SUF.[LENGTH] < COL.[SystemSize])
        OR (    COL.[SystemType] = 'decimal'
            AND SUF.[DECMIAL] < COL.[SystemDecimals]))

UPDATE SUF
   SET SUF.[DECMIAL] = 0,
       SUF.[FORMAT] = CASE WHEN SUF.[FORMAT] NOT LIKE '@d%'
                                THEN '@d6'
                           ELSE SUF.[FORMAT] END,
       SUF.[LENGTH] = CASE WHEN SUF.[FORMAT] NOT LIKE '@d%'
                                THEN 10
                           WHEN CONVERT(INT, SUBSTRING(SUF.[FORMAT], 3, LEN(SUF.[FORMAT]) - 2)) = 6
                            AND SUF.[LENGTH] <> 10
                                THEN 10
                           WHEN CONVERT(INT, SUBSTRING(SUF.[FORMAT], 3, LEN(SUF.[FORMAT]) - 2)) <> 6
                            AND CONVERT(INT, SUBSTRING(SUF.[FORMAT], 3, LEN(SUF.[FORMAT]) - 2)) <> SUF.[LENGTH]
                                THEN CONVERT(INT, SUBSTRING(SUF.[FORMAT], 3, LEN(SUF.[FORMAT]) - 2))
                           ELSE SUF.[LENGTH] END
  FROM [dbo].[SystemUserDefinedFields] SUF
       OUTER APPLY (SELECT SC.[name] AS [SystemField],
                           ST.[name] AS [SystemType],
                           CASE WHEN SC.[Precision] > 0 THEN SC.[Precision] ELSE SC.[max_length] END AS [SystemSize],
                           SC.[scale] AS [SystemDecimals]
                      FROM SYS.[objects] SO
                           INNER JOIN SYS.[columns] SC
                                      INNER JOIN SYS.[types] ST
                                              ON ST.[system_type_id] = SC.[system_type_id]
                                   ON SC.[object_id] = SO.[object_id]
                                  AND 1 = CASE WHEN SC.[name] = SUF.[FIELDNAME]
                                                    THEN 1
                                               WHEN SC.[name] = SUF.[FIELDNAME] + '_DATE'
                                                    THEN 1
                                               WHEN CHARINDEX(':', SUF.[ACTUALNAME], 1) = 0
                                                    THEN 0
                                               WHEN SC.[name] = SUBSTRING(SUF.[ActualName], CHARINDEX(':', SUF.[ACTUALNAME], 1) + 1, LEN(SUF.[ACTUALNAME]) - CHARINDEX(':', SUF.[ACTUALNAME], 1))
                                                    THEN 1
                                               ELSE 0 END
                     WHERE SO.[name] = [dbo].[ky_NETFNSystemTable](SUF.[FILEPREFIX])
                       AND SO.[type] = 'U') COL
 WHERE ISNUMERIC(SUF.[FORMAT]) = 0
   AND SUF.[FORMAT] <> ''
   AND SUF.[FILEPREFIX] <> 'UDF:'
   AND COL.[SystemField] IS NOT NULL
   AND ISNULL(SUF.[ACTUALNAME], '') = ''
   AND COL.[SystemType] = 'datetime'
   AND 1 = CASE WHEN SUF.[FORMAT] NOT LIKE '@d%'
                     THEN 1
                WHEN CONVERT(INT, SUBSTRING(SUF.[FORMAT], 3, LEN(SUF.[FORMAT]) - 2)) = 6
                 AND SUF.[LENGTH] <> 10
                     THEN 1
                WHEN CONVERT(INT, SUBSTRING(SUF.[FORMAT], 3, LEN(SUF.[FORMAT]) - 2)) <> 6
                 AND CONVERT(INT, SUBSTRING(SUF.[FORMAT], 3, LEN(SUF.[FORMAT]) - 2)) <> SUF.[LENGTH]
                     THEN 1
                WHEN SUF.[DECMIAL] <> 0
                     THEN 1
                ELSE 0 END

UPDATE SUF
   SET SUF.[FORMAT] = '@n' + CASE WHEN COL.[SystemType] IN ('int', 'smallint')
                                       THEN CONVERT(VARCHAR(3), SUF.[LENGTH])
                                  ELSE CONVERT(VARCHAR(3), COL.[systemsize]) + '.' + CONVERT(VARCHAR(3), COL.[SystemDecimals]) END,
       SUF.[LENGTH] = CASE WHEN COL.[SystemType] IN ('int', 'smallint')
                                THEN SUF.[LENGTH] -- do not touch!
                           ELSE COL.[SystemSize] END,
       SUF.[DECMIAL] = CASE WHEN COL.[SystemType] IN ('int', 'smallint')
                                 THEN 0
                            ELSE COL.[SystemDecimals] END
  FROM [dbo].[SystemUserDefinedFields] SUF
       OUTER APPLY (SELECT SC.[name] AS [SystemField],
                           ST.[name] AS [SystemType],
                           CASE WHEN SC.[Precision] > 0 THEN SC.[Precision] ELSE SC.[max_length] END AS [SystemSize],
                           SC.[scale] AS [SystemDecimals]
                      FROM SYS.[objects] SO
                           INNER JOIN SYS.[columns] SC
                                      INNER JOIN SYS.[types] ST
                                              ON ST.[system_type_id] = SC.[system_type_id]
                                   ON SC.[object_id] = SO.[object_id]
                                  AND 1 = CASE WHEN SC.[name] = SUF.[FIELDNAME]
                                                    THEN 1
                                               WHEN SC.[name] = SUF.[FIELDNAME] + '_DATE'
                                                    THEN 1
                                               WHEN CHARINDEX(':', SUF.[ACTUALNAME], 1) = 0
                                                    THEN 0
                                               WHEN SC.[name] = SUBSTRING(SUF.[ActualName], CHARINDEX(':', SUF.[ACTUALNAME], 1) + 1, LEN(SUF.[ACTUALNAME]) - CHARINDEX(':', SUF.[ACTUALNAME], 1))
                                                    THEN 1
                                               ELSE 0 END
                     WHERE SO.[name] = [dbo].[ky_NETFNSystemTable](SUF.[FILEPREFIX])
                       AND SO.[type] = 'U') COL
 WHERE ISNUMERIC(SUF.[FORMAT]) = 0
   AND SUF.[FORMAT] <> ''
   AND SUF.[FILEPREFIX] <> 'UDF:'
   AND ISNULL(SUF.[ACTUALNAME], '') <> ''
   AND COL.[SystemType] NOT IN ('char', 'varchar', 'datetime')
   AND SUF.[FORMAT] NOT LIKE '@n%'

UPDATE SUF
   SET SUF.[DECMIAL] = 0,
       SUF.[FORMAT] = CASE WHEN SUF.[FORMAT] NOT LIKE '@d%'
                                THEN '@d6'
                           ELSE SUF.[FORMAT] END,
       SUF.[LENGTH] = CASE WHEN SUF.[FORMAT] NOT LIKE '@d%'
                                THEN 10
                           WHEN CONVERT(INT, SUBSTRING(SUF.[FORMAT], 3, LEN(SUF.[FORMAT]) - 2)) = 6
                            AND SUF.[LENGTH] <> 10
                                THEN 10
                           WHEN CONVERT(INT, SUBSTRING(SUF.[FORMAT], 3, LEN(SUF.[FORMAT]) - 2)) <> 6
                            AND CONVERT(INT, SUBSTRING(SUF.[FORMAT], 3, LEN(SUF.[FORMAT]) - 2)) <> SUF.[LENGTH]
                                THEN CONVERT(INT, SUBSTRING(SUF.[FORMAT], 3, LEN(SUF.[FORMAT]) - 2))
                           ELSE SUF.[LENGTH] END
  FROM [dbo].[SystemUserDefinedFields] SUF
       OUTER APPLY (SELECT SC.[name] AS [SystemField],
                           ST.[name] AS [SystemType],
                           CASE WHEN SC.[Precision] > 0 THEN SC.[Precision] ELSE SC.[max_length] END AS [SystemSize],
                           SC.[scale] AS [SystemDecimals]
                      FROM SYS.[objects] SO
                           INNER JOIN SYS.[columns] SC
                                      INNER JOIN SYS.[types] ST
                                              ON ST.[system_type_id] = SC.[system_type_id]
                                   ON SC.[object_id] = SO.[object_id]
                                  AND 1 = CASE WHEN SC.[name] = SUF.[FIELDNAME]
                                                    THEN 1
                                               WHEN SC.[name] = SUF.[FIELDNAME] + '_DATE'
                                                    THEN 1
                                               WHEN CHARINDEX(':', SUF.[ACTUALNAME], 1) = 0
                                                    THEN 0
                                               WHEN SC.[name] = SUBSTRING(SUF.[ActualName], CHARINDEX(':', SUF.[ACTUALNAME], 1) + 1, LEN(SUF.[ACTUALNAME]) - CHARINDEX(':', SUF.[ACTUALNAME], 1))
                                                    THEN 1
                                               ELSE 0 END
                     WHERE SO.[name] = [dbo].[ky_NETFNSystemTable](SUF.[FILEPREFIX])
                       AND SO.[type] = 'U') COL
 WHERE ISNUMERIC(SUF.[FORMAT]) = 0
   AND SUF.[FORMAT] <> ''
   AND SUF.[FILEPREFIX] <> 'UDF:'
   AND ISNULL(SUF.[ACTUALNAME], '') <> ''
   AND COL.[SystemType] = 'datetime'
   AND 1 = CASE WHEN SUF.[FORMAT] NOT LIKE '@d%'
                     THEN 1
                WHEN CONVERT(INT, SUBSTRING(SUF.[FORMAT], 3, LEN(SUF.[FORMAT]) - 2)) = 6
                 AND SUF.[LENGTH] <> 10
                     THEN 1
                WHEN CONVERT(INT, SUBSTRING(SUF.[FORMAT], 3, LEN(SUF.[FORMAT]) - 2)) <> 6
                 AND CONVERT(INT, SUBSTRING(SUF.[FORMAT], 3, LEN(SUF.[FORMAT]) - 2)) <> SUF.[LENGTH]
                     THEN 1
                WHEN SUF.[DECMIAL] <> 0
                     THEN 1
                ELSE 0 END

UPDATE SUF
   SET SUF.[LENGTH] = CASE WHEN COL.[SystemSize] < 0 -- (MAX)
                                THEN 4000
                           WHEN COL.[SystemSize] > 4000
                                THEN 4000
                           ELSE COL.[SystemSize] END,
       SUF.[FORMAT] = CASE WHEN COL.[SystemSize] < 0 -- (MAX)
                                THEN ''
                           WHEN COL.[SystemSize] > 4000
                                THEN ''
                           ELSE '@s' + CONVERT(VARCHAR(10), COL.[SystemSize]) END
  FROM [dbo].[SystemUserDefinedFields] SUF
       OUTER APPLY (SELECT SC.[name] AS [SystemField],
                           ST.[name] AS [SystemType],
                           CASE WHEN SC.[Precision] > 0 THEN SC.[Precision] ELSE SC.[max_length] END AS [SystemSize],
                           SC.[scale] AS [SystemDecimals]
                      FROM SYS.[objects] SO
                           INNER JOIN SYS.[columns] SC
                                      INNER JOIN SYS.[types] ST
                                              ON ST.[system_type_id] = SC.[system_type_id]
                                   ON SC.[object_id] = SO.[object_id]
                                  AND 1 = CASE WHEN SC.[name] = SUF.[FIELDNAME]
                                                    THEN 1
                                               WHEN SC.[name] = SUF.[FIELDNAME] + '_DATE'
                                                    THEN 1
                                               WHEN CHARINDEX(':', SUF.[ACTUALNAME], 1) = 0
                                                    THEN 0
                                               WHEN SC.[name] = SUBSTRING(SUF.[ActualName], CHARINDEX(':', SUF.[ACTUALNAME], 1) + 1, LEN(SUF.[ACTUALNAME]) - CHARINDEX(':', SUF.[ACTUALNAME], 1))
                                                    THEN 1
                                               ELSE 0 END
                     WHERE SO.[name] = [dbo].[ky_NETFNSystemTable](SUF.[FILEPREFIX])
                       AND SO.[type] = 'U') COL
 WHERE ISNUMERIC(SUF.[FORMAT]) = 0
   AND SUF.[FORMAT] <> ''
   AND SUF.[FILEPREFIX] <> 'UDF:'
   AND ISNULL(SUF.[ACTUALNAME], '') <> ''
   AND COL.[SystemType] IN ('char', 'varchar')
   AND 1 = CASE WHEN SUF.[FORMAT] NOT LIKE '@s%'
                     THEN 1
                WHEN COL.[SystemSize] = -1
                 AND SUF.[FORMAT] <> ''
                     THEN 1
                WHEN COL.[SystemSize] > 4000
                 AND SUF.[FORMAT] <> ''
                     THEN 1
                WHEN CONVERT(INT, REPLACE(SUF.[FORMAT], '@s', '')) < COL.[SystemSize]
                     THEN 1
                WHEN SUF.[LENGTH] < COL.[SystemSize]
                     THEN 1
                ELSE 0 END

UPDATE SUF
   SET SUF.[LENGTH] = CASE WHEN COL.[SystemSize] = -1
                                THEN 4000
                           WHEN COL.[SystemSize] > 4000
                                THEN 4000
                           ELSE COL.[SystemSize] END,
       SUF.[FORMAT] = CASE WHEN COL.[SystemSize] = -1
                                THEN ''
                           WHEN COL.[SystemSize] > 4000
                                THEN ''
                           ELSE '@s' + CONVERT(VARCHAR(10), COL.[SystemSize]) END
  FROM [dbo].[SystemUserDefinedFields] SUF
       OUTER APPLY (SELECT SC.[name] AS [SystemField],
                           ST.[name] AS [SystemType],
                           CASE WHEN SC.[Precision] > 0 THEN SC.[Precision] ELSE SC.[max_length] END AS [SystemSize],
                           SC.[scale] AS [SystemDecimals]
                      FROM SYS.[objects] SO
                           INNER JOIN SYS.[columns] SC
                                      INNER JOIN SYS.[types] ST
                                              ON ST.[system_type_id] = SC.[system_type_id]
                                   ON SC.[object_id] = SO.[object_id]
                                  AND (   SC.[name] = SUF.[FIELDNAME]
                                       OR SC.[name] = SUF.[FIELDNAME] + '_DATE')
                     WHERE SO.[name] = [dbo].[ky_NETFNSystemTable](SUF.[FILEPREFIX])
                       AND SO.[type] = 'U') COL
 WHERE (   ISNUMERIC(SUF.[FORMAT]) = 1
        OR ISNULL(SUF.[FORMAT], '') = '')
   AND SUF.[FILEPREFIX] <> 'UDF:'
   AND COL.[SystemField] IS NOT NULL
   AND (   (    COL.[SystemSize] <> -1
            AND COL.[SystemSize] < 4000
            AND SUF.[LENGTH] <> COL.[SystemSize])
        OR (    COL.[SystemSize] = -1
            AND SUF.[LENGTH] <> 4000)
        OR (    COL.[SystemSize] >= 4000
            AND SUF.[LENGTH] <> 4000))

UPDATE SUF
   SET SUF.[FORMAT] = '@s' + CONVERT(VARCHAR(10), SUF.[LENGTH]),
       SUF.[DECMIAL] = 0
  FROM [dbo].[SystemUserDefinedFields] SUF
 WHERE SUF.[FORMAT] LIKE '@s%'
   AND ISNUMERIC(SUBSTRING(SUF.[FORMAT], 3, LEN(SUF.[FORMAT]) - 2)) = 0

UPDATE SUF
   SET SUF.[LENGTH] = 0,
       SUF.[FORMAT] = ''
  FROM [dbo].[SystemUserDefinedFields] SUF
       OUTER APPLY (SELECT SC.[name] AS [SystemField],
                           ST.[name] AS [SystemType],
                           CASE WHEN SC.[Precision] > 0 THEN SC.[Precision] ELSE SC.[max_length] END AS [SystemSize],
                           SC.[scale] AS [SystemDecimals]
                      FROM SYS.[objects] SO
                           INNER JOIN SYS.[columns] SC
                                      INNER JOIN SYS.[types] ST
                                              ON ST.[system_type_id] = SC.[system_type_id]
                                   ON SC.[object_id] = SO.[object_id]
                                  AND 1 = CASE WHEN SC.[name] = SUF.[FIELDNAME]
                                                    THEN 1
                                               WHEN SC.[name] = SUF.[FIELDNAME] + '_DATE'
                                                    THEN 1
                                               WHEN CHARINDEX(':', SUF.[ACTUALNAME], 1) = 0
                                                    THEN 0
                                               WHEN SC.[name] = SUBSTRING(SUF.[ActualName], CHARINDEX(':', SUF.[ACTUALNAME], 1) + 1, LEN(SUF.[ACTUALNAME]) - CHARINDEX(':', SUF.[ACTUALNAME], 1))
                                                    THEN 1
                                               ELSE 0 END
                     WHERE SO.[name] = [dbo].[ky_NETFNSystemTable](SUF.[FILEPREFIX])
                       AND SO.[type] = 'U') COL
 WHERE COL.[SystemType] IN ('char', 'varchar')
   AND COL.[SystemSize] > 255
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.2.67
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.2.68
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 68, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.2.2.68'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
UPDATE matters SET StatuteLimits = null WHERE StatuteLimits = '1900-01-01 00:00:00.000'
GO
UPDATE matters SET ExpBillD = null WHERE ExpBillD = '1900-01-01 00:00:00.000'
GO
UPDATE matters SET DestroyDate = null WHERE DestroyDate = '1900-01-01 00:00:00.000'
GO
UPDATE matters SET ActualDestroyDate = null WHERE ActualDestroyDate = '1900-01-01 00:00:00.000'
GO
UPDATE matters SET closingDate = null WHERE closingDate = '1900-01-01 00:00:00.000'
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.2.68
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.2.69
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 69, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.2.2.69'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
INSERT
  INTO [dbo].[SystemUserDefinedFields]
      ([FILEPREFIX],
       [FIELDNAME],
       [TYPE],
       [PROMPT],
       [LENGTH],
       [DECMIAL],
       [FORMAT],
       [INITIALVALUE],
       [CALCINITIALVALUE],
       [OVERRIDEINITIALVALUE],
       [REQUIRED],
       [VALIDATION],
       [LOW],
       [HIGH],
       [SYSTEMFIELD],
       [TOP],
       [LEFT],
       [HEIGHT],
       [WIDTH],
       [FONT],
       [VISIBLE],
       [ENABLED],
       [READONLY],
       [MULTILINE],
       [ACTUALNAME],
       [COMMON],
       [UDFCategory],
       [ISLOCK],
       [SQLStatement])
SELECT 'CAN:'                                              AS [FILEPREFIX],
       CASE WHEN SO.[name] = 'CaseAssociatesContacts'
                 THEN 'Assign' + SC.[name]
            ELSE SC.[name] END                             AS [FIELDNAME],
       'System'                                            AS [TYPE],
       ISNULL(SUP.[PROMPT],
              SC.[name])                                   AS [PROMPT],
       CASE WHEN ST.[name] IN ('char',
                               'varchar')
                 THEN SC.[max_length]
            WHEN ST.[name] = 'datetime'
                 THEN 10
            WHEN ST.[name] IN ('int',
                               'bit',
                               'smallint')
                 THEN ST.[precision]
            ELSE ST.[precision] END                        AS [LENGTH],
       CASE WHEN ST.[name] IN ('char',
                               'varchar')
                 THEN 0
            WHEN ST.[name] = 'datetime'
                 THEN 0
            WHEN ST.[name] IN ('int',
                               'bit',
                               'smallint')
                 THEN 0
            ELSE 0 END                                     AS [DECMIAL],
       CASE WHEN ST.[name] IN ('char',
                               'varchar')
             AND SC.[max_length] > 255
                 THEN ''
            WHEN ST.[name] IN ('char',
                               'varchar')
                 THEN   '@s' 
                      + CONVERT(VARCHAR(10),
                                SC.[max_length])
            WHEN ST.[name] = 'datetime'
                 THEN '@d18'
            WHEN ST.[name] IN ('int',
                               'bit',
                               'smallint')
                 THEN   '@n'
                      + CONVERT(VARCHAR(10),
                                SC.[precision])
            WHEN SC.[scale] = 0
                 THEN   '@n'
                      + CONVERT(VARCHAR(10),
                                SC.[precision])
            ELSE   '@n'
                 + CONVERT(VARCHAR(10),
                           SC.[precision])
                 + '.'
                 + CONVERT(VARCHAR(10),
                           SC.[scale]) END                 AS [FORMAT],
       ''                                                  AS [INITIALVALUE],
       'N'                                                 AS [CALCINITIALVALUE],
       'N'                                                 AS [OVERRIDEINITIALVALUE],
       'N'                                                 AS [REQUIRED],
       'N'                                                 AS [VALIDATION],
       0                                                   AS [LOW],
       0                                                   AS [HIGH],
       'N'                                                 AS [SYSTEMFIELD],
       0                                                   AS [TOP],
       0                                                   AS [LEFT],
       0                                                   AS [HEIGHT],
       0                                                   AS [WIDTH],
       ''                                                  AS [FONT],
       'Y'                                                 AS [VISIBLE],
       'Y'                                                 AS [ENABLED],
       'N'                                                 AS [READONLY],
       'N'                                                 AS [MULTILINE],
       CASE WHEN SO.[name] = 'CaseAssociatesContacts'
             AND SC2.[name] IS NOT NULL
                 THEN 'CHOOSE(clip(NAC:' + SC.[name] + ')='''', NAM:' + SC.[name] + ', NAC:' + SC.[name] + ')'
            WHEN SO.[name] = 'CaseAssociatesContacts'
                 THEN 'NAC:' + SC.[name]
            WHEN SO.[name] = 'CaseContacts'
             AND SC2.[name] IS NOT NULL
                 THEN 'CHOOSE(clip(CC:' + SC.[name] + ')='''', NAM:' + SC.[name] + ', CC:' + SC.[name] + ')'
            WHEN SO.[name] = 'CaseContacts'
                 THEN 'CC:' + SC.[name]
            ELSE '' END                                    AS [ACTUALNAME],
       1                                                   AS [COMMON],
       NULL                                                AS [UDFCategory],
       0                                                   AS [ISLOCK],
       NULL                                                AS [SQLStatement]
  FROM SYS.[objects] SO
       INNER JOIN SYS.[columns] SC
                  INNER JOIN SYS.[types] ST
                          ON ST.[system_type_id] = SC.[system_type_id]
               ON SC.[object_id] = SO.[object_id]
              AND (   SO.[name] <> 'CaseAssociatesNames'
                   OR SC.[name] <> 'Retired')
       LEFT OUTER JOIN [dbo].[SystemUserDefinedFields] SUF
                    ON SUF.[FILEPREFIX] = 'CAN:'
                   AND (   (    SO.[name] <> 'CaseAssociatesContacts'
                            AND SUF.[FIELDNAME] = SC.[name])
                        OR (    SO.[name] = 'CaseAssociatesContacts'
                            AND SUF.[FIELDNAME] = 'Assign' + SC.[name]))
       LEFT OUTER JOIN SYS.[objects] SO2
                    ON SO2.[name] = 'CaseAssociatesNames'
                   AND SO2.[type] = 'U'
       LEFT OUTER JOIN SYS.[columns] SC2
                    ON SC2.[object_id] = SO2.[object_id]
                   AND SC2.[name] = SC.[name]
       OUTER APPLY (SELECT TOP 1 SUF2.[PROMPT]
                      FROM [dbo].[SystemUserDefinedFields] SUF2
                     WHERE SUF2.[FieldName] = SC.[name]) SUP
 WHERE SO.[name] IN ('CaseAssociatesNames', 'CaseAssociatesContacts', 'CaseContacts')
   AND SUF.[FILEPREFIX] IS NULL
GO

UPDATE SUF
   SET SUF.[ACTUALNAME] = CASE WHEN SO.[name] = 'CaseAssociatesContacts'
                                AND SC2.[name] IS NOT NULL
                                    THEN 'CHOOSE(clip(NAC:' + SC.[name] + ')='''', NAM:' + SC.[name] + ', NAC:' + SC.[name] + ')'
                               WHEN SO.[name] = 'CaseAssociatesContacts'
                                    THEN 'NAC:' + SC.[name]
                               WHEN SO.[name] = 'CaseContacts'
                                AND SC2.[name] IS NOT NULL
                                    THEN 'CHOOSE(clip(CC:' + SC.[name] + ')='''', NAM:' + SC.[name] + ', CC:' + SC.[name] + ')'
                               WHEN SO.[name] = 'CaseContacts'
                                    THEN 'CC:' + SC.[name]
                               ELSE '' END
  FROM SYS.[objects] SO
       INNER JOIN SYS.[columns] SC
                  INNER JOIN SYS.[types] ST
                          ON ST.[system_type_id] = SC.[system_type_id]
               ON SC.[object_id] = SO.[object_id]
       LEFT OUTER JOIN [dbo].[SystemUserDefinedFields] SUF
                    ON SUF.[FILEPREFIX] = 'CAN:'
                   AND (   (    SO.[name] <> 'CaseAssociatesContacts'
                            AND SUF.[FIELDNAME] = SC.[name])
                        OR (    SO.[name] = 'CaseAssociatesContacts'
                            AND SUF.[FIELDNAME] = 'Assign' + SC.[name]))
       LEFT OUTER JOIN SYS.[objects] SO2
                    ON SO2.[name] = 'CaseAssociatesNames'
                   AND SO2.[type] = 'U'
       LEFT OUTER JOIN SYS.[columns] SC2
                    ON SC2.[object_id] = SO2.[object_id]
                   AND SC2.[name] = SC.[name]
       OUTER APPLY (SELECT TOP 1 SUF2.[PROMPT]
                      FROM [dbo].[SystemUserDefinedFields] SUF2
                     WHERE SUF2.[FieldName] = SC.[name]) SUP
 WHERE SO.[name] IN ('CaseAssociatesNames', 'CaseAssociatesContacts', 'CaseContacts')
   AND SUF.[ACTUALNAME] <> CASE WHEN SO.[name] = 'CaseAssociatesContacts'
                                 AND SC2.[name] IS NOT NULL
                                     THEN 'CHOOSE(clip(NAC:' + SC.[name] + ')='''', NAM:' + SC.[name] + ', NAC:' + SC.[name] + ')'
                                WHEN SO.[name] = 'CaseAssociatesContacts'
                                     THEN 'NAC:' + SC.[name]
                                WHEN SO.[name] = 'CaseContacts'
                                 AND SC2.[name] IS NOT NULL
                                     THEN 'CHOOSE(clip(CC:' + SC.[name] + ')='''', NAM:' + SC.[name] + ', CC:' + SC.[name] + ')'
                                WHEN SO.[name] = 'CaseContacts'
                                     THEN 'CC:' + SC.[name]
                                ELSE '' END
   AND LTRIM(RTRIM(SUF.[ACTUALNAME])) NOT LIKE 'NAM:%'
GO

INSERT
  INTO [dbo].[SystemUserDefinedFields]
      ([FILEPREFIX],
       [FIELDNAME],
       [TYPE],
       [PROMPT],
       [LENGTH],
       [DECMIAL],
       [FORMAT],
       [INITIALVALUE],
       [CALCINITIALVALUE],
       [OVERRIDEINITIALVALUE],
       [REQUIRED],
       [VALIDATION],
       [LOW],
       [HIGH],
       [SYSTEMFIELD],
       [TOP],
       [LEFT],
       [HEIGHT],
       [WIDTH],
       [FONT],
       [VISIBLE],
       [ENABLED],
       [READONLY],
       [MULTILINE],
       [ACTUALNAME],
       [COMMON],
       [UDFCategory],
       [ISLOCK],
       [SQLStatement])
SELECT 'CNT:'                                              AS [FILEPREFIX],
       SC.[name]                                           AS [FIELDNAME],
       'System'                                            AS [TYPE],
       ISNULL(SUP.[PROMPT],
              SC.[name])                                   AS [PROMPT],
       CASE WHEN ST.[name] IN ('char',
                               'varchar')
                 THEN SC.[max_length]
            WHEN ST.[name] = 'datetime'
                 THEN 10
            WHEN ST.[name] IN ('int',
                               'bit',
                               'smallint')
                 THEN ST.[precision]
            ELSE ST.[precision] END                        AS [LENGTH],
       CASE WHEN ST.[name] IN ('char',
                               'varchar')
                 THEN 0
            WHEN ST.[name] = 'datetime'
                 THEN 0
            WHEN ST.[name] IN ('int',
                               'bit',
                               'smallint')
                 THEN 0
            ELSE 0 END                                     AS [DECMIAL],
       CASE WHEN ST.[name] IN ('char',
                               'varchar')
             AND SC.[max_length] > 255
                 THEN ''
            WHEN ST.[name] IN ('char',
                               'varchar')
                 THEN   '@s' 
                      + CONVERT(VARCHAR(10),
                                SC.[max_length])
            WHEN ST.[name] = 'datetime'
                 THEN '@d18'
            WHEN ST.[name] IN ('int',
                               'bit',
                               'smallint')
                 THEN   '@n'
                      + CONVERT(VARCHAR(10),
                                SC.[precision])
            WHEN SC.[scale] = 0
                 THEN   '@n'
                      + CONVERT(VARCHAR(10),
                                SC.[precision])
            ELSE   '@n'
                 + CONVERT(VARCHAR(10),
                           SC.[precision])
                 + '.'
                 + CONVERT(VARCHAR(10),
                           SC.[scale]) END                 AS [FORMAT],
       ''                                                  AS [INITIALVALUE],
       'N'                                                 AS [CALCINITIALVALUE],
       'N'                                                 AS [OVERRIDEINITIALVALUE],
       'N'                                                 AS [REQUIRED],
       'N'                                                 AS [VALIDATION],
       0                                                   AS [LOW],
       0                                                   AS [HIGH],
       'N'                                                 AS [SYSTEMFIELD],
       0                                                   AS [TOP],
       0                                                   AS [LEFT],
       0                                                   AS [HEIGHT],
       0                                                   AS [WIDTH],
       ''                                                  AS [FONT],
       'Y'                                                 AS [VISIBLE],
       'Y'                                                 AS [ENABLED],
       'N'                                                 AS [READONLY],
       'N'                                                 AS [MULTILINE],
       ''                                                  AS [ACTUALNAME],
       1                                                   AS [COMMON],
       NULL                                                AS [UDFCategory],
       0                                                   AS [ISLOCK],
       NULL                                                AS [SQLStatement]
  FROM SYS.[objects] SO
       INNER JOIN SYS.[columns] SC
                  INNER JOIN SYS.[types] ST
                          ON ST.[system_type_id] = SC.[system_type_id]
               ON SC.[object_id] = SO.[object_id]
       LEFT OUTER JOIN [dbo].[SystemUserDefinedFields] SUF
                    ON SUF.[FILEPREFIX] = 'CNT:'
                   AND SUF.[FIELDNAME] = SC.[name]
       OUTER APPLY (SELECT TOP 1 SUF2.[PROMPT]
                      FROM [dbo].[SystemUserDefinedFields] SUF2
                     WHERE SUF2.[FieldName] = SC.[name]) SUP
 WHERE SO.[name] IN ('Contacts')
   AND SUF.[FILEPREFIX] IS NULL
GO

IF NOT EXISTS
  (SELECT TOP 1 1
     FROM [dbo].[SystemUserDefinedFields] SUF
    WHERE SUF.[FILEPREFIX] = 'CAN:'
      AND SUF.[FIELDNAME] = 'AssignPostalCode')
  BEGIN
    INSERT
      INTO [dbo].[SystemUserDefinedFields]
          ([FILEPREFIX],
           [FIELDNAME],
           [TYPE],
           [PROMPT],
           [LENGTH],
           [DECMIAL],
           [FORMAT],
           [INITIALVALUE],
           [CALCINITIALVALUE],
           [OVERRIDEINITIALVALUE],
           [REQUIRED],
           [VALIDATION],
           [LOW],
           [HIGH],
           [SYSTEMFIELD],
           [TOP],
           [LEFT],
           [HEIGHT],
           [WIDTH],
           [FONT],
           [VISIBLE],
           [ENABLED],
           [READONLY],
           [MULTILINE],
           [ACTUALNAME],
           [COMMON],
           [UDFCategory],
           [ISLOCK],
           [SQLStatement])
    SELECT 'CAN:'                                                               AS [FILEPREFIX],
           'AssignPostalCode'                                                   AS [FIELDNAME],
           'System'                                                             AS [TYPE],
           'Assigned Postal Code'                                               AS [PROMPT],
           100                                                                  AS [LENGTH],
           0                                                                    AS [DECMIAL],
           '@s100'                                                              AS [FORMAT],
           ''                                                                   AS [INITIALVALUE],
           'N'                                                                  AS [CALCINITIALVALUE],
           'N'                                                                  AS [OVERRIDEINITIALVALUE],
           'N'                                                                  AS [REQUIRED],
           'N'                                                                  AS [VALIDATION],
           0                                                                    AS [LOW],
           0                                                                    AS [HIGH],
           'N'                                                                  AS [SYSTEMFIELD],
           0                                                                    AS [TOP],
           0                                                                    AS [LEFT],
           0                                                                    AS [HEIGHT],
           0                                                                    AS [WIDTH],
           ''                                                                   AS [FONT],
           'Y'                                                                  AS [VISIBLE],
           'Y'                                                                  AS [ENABLED],
           'N'                                                                  AS [READONLY],
           'N'                                                                  AS [MULTILINE],
           'CHOOSE(clip(NAC:PostalCode)='''',NAM:PostalCode, NAC:PostalCode)'   AS [ACTUALNAME],
           1                                                                    AS [COMMON],
           NULL                                                                 AS [UDFCategory],
           0                                                                    AS [ISLOCK],
           NULL                                                                 AS [SQLStatement]
  END
ELSE
  BEGIN
    UPDATE SUF
       SET [FILEPREFIX]             = 'CAN:',
           [FIELDNAME]              = 'AssignPostalCode',
           [TYPE]                   = 'System',
           [PROMPT]                 = 'Assigned Postal Code',
           [LENGTH]                 = 100,
           [DECMIAL]                = 0,
           [FORMAT]                 = '@s100',
           [INITIALVALUE]           = '',
           [CALCINITIALVALUE]       = 'N',
           [OVERRIDEINITIALVALUE]   = 'N',
           [REQUIRED]               = 'N',
           [VALIDATION]             = 'N',
           [LOW]                    = 0,
           [HIGH]                   = 0,
           [SYSTEMFIELD]            = 'N',
           [TOP]                    = 0,
           [LEFT]                   = 0,
           [HEIGHT]                 = 0,
           [WIDTH]                  = 0,
           [FONT]                   = '',
           [VISIBLE]                = 'Y',
           [ENABLED]                = 'Y',
           [READONLY]               = 'N',
           [MULTILINE]              = 'N',
           [ACTUALNAME]             = 'CHOOSE(clip(NAC:PostalCode)='''',NAM:PostalCode, NAC:PostalCode)',
           [COMMON]                 = 1,
           [UDFCategory]            = NULL,
           [ISLOCK]                 = 0,
           [SQLStatement]           = NULL
      FROM [dbo].[SystemUserDefinedFields] SUF
     WHERE SUF.[FILEPREFIX] = 'CAN:'
       AND SUF.[FIELDNAME] = 'AssignPostalCode'
       AND SUF.[PROMPT] <> 'Assigned Postal Code'
  END
GO

IF NOT EXISTS
  (SELECT TOP 1 1
     FROM [dbo].[SystemUserDefinedFields] SUF
    WHERE SUF.[FILEPREFIX] = 'CAN:'
      AND SUF.[FIELDNAME] = 'PostalCode')
  BEGIN
    INSERT
      INTO [dbo].[SystemUserDefinedFields]
          ([FILEPREFIX],
           [FIELDNAME],
           [TYPE],
           [PROMPT],
           [LENGTH],
           [DECMIAL],
           [FORMAT],
           [INITIALVALUE],
           [CALCINITIALVALUE],
           [OVERRIDEINITIALVALUE],
           [REQUIRED],
           [VALIDATION],
           [LOW],
           [HIGH],
           [SYSTEMFIELD],
           [TOP],
           [LEFT],
           [HEIGHT],
           [WIDTH],
           [FONT],
           [VISIBLE],
           [ENABLED],
           [READONLY],
           [MULTILINE],
           [ACTUALNAME],
           [COMMON],
           [UDFCategory],
           [ISLOCK],
           [SQLStatement])
    SELECT 'CAN:'                                                               AS [FILEPREFIX],
           'PostalCode'                                                         AS [FIELDNAME],
           'System'                                                             AS [TYPE],
           'Postal Code'                                                        AS [PROMPT],
           100                                                                  AS [LENGTH],
           0                                                                    AS [DECMIAL],
           '@s100'                                                              AS [FORMAT],
           ''                                                                   AS [INITIALVALUE],
           'N'                                                                  AS [CALCINITIALVALUE],
           'N'                                                                  AS [OVERRIDEINITIALVALUE],
           'N'                                                                  AS [REQUIRED],
           'N'                                                                  AS [VALIDATION],
           0                                                                    AS [LOW],
           0                                                                    AS [HIGH],
           'N'                                                                  AS [SYSTEMFIELD],
           0                                                                    AS [TOP],
           0                                                                    AS [LEFT],
           0                                                                    AS [HEIGHT],
           0                                                                    AS [WIDTH],
           ''                                                                   AS [FONT],
           'Y'                                                                  AS [VISIBLE],
           'Y'                                                                  AS [ENABLED],
           'N'                                                                  AS [READONLY],
           'N'                                                                  AS [MULTILINE],
           'NAM:PostalCode'                                                     AS [ACTUALNAME],
           1                                                                    AS [COMMON],
           NULL                                                                 AS [UDFCategory],
           0                                                                    AS [ISLOCK],
           NULL                                                                 AS [SQLStatement]
  END
ELSE
  BEGIN
    UPDATE SUF
       SET [FILEPREFIX]             = 'CAN:',
           [FIELDNAME]              = 'PostalCode',
           [TYPE]                   = 'System',
           [PROMPT]                 = 'Postal Code',
           [LENGTH]                 = 100,
           [DECMIAL]                = 0,
           [FORMAT]                 = '@s100',
           [INITIALVALUE]           = '',
           [CALCINITIALVALUE]       = 'N',
           [OVERRIDEINITIALVALUE]   = 'N',
           [REQUIRED]               = 'N',
           [VALIDATION]             = 'N',
           [LOW]                    = 0,
           [HIGH]                   = 0,
           [SYSTEMFIELD]            = 'N',
           [TOP]                    = 0,
           [LEFT]                   = 0,
           [HEIGHT]                 = 0,
           [WIDTH]                  = 0,
           [FONT]                   = '',
           [VISIBLE]                = 'Y',
           [ENABLED]                = 'Y',
           [READONLY]               = 'N',
           [MULTILINE]              = 'N',
           [ACTUALNAME]             = 'NAM:PostalCode',
           [COMMON]                 = 1,
           [UDFCategory]            = NULL,
           [ISLOCK]                 = 0,
           [SQLStatement]           = NULL
      FROM [dbo].[SystemUserDefinedFields] SUF
     WHERE SUF.[FILEPREFIX] = 'CAN:'
       AND SUF.[FIELDNAME] = 'PostalCode'
       AND SUF.[PROMPT] <> 'Postal Code'
  END
GO

IF NOT EXISTS
  (SELECT TOP 1 1
     FROM [dbo].[SystemUserDefinedFields] SUF
    WHERE SUF.[FILEPREFIX] = 'CNT:'
      AND SUF.[FIELDNAME] = 'PostalCode')
  BEGIN
    INSERT
      INTO [dbo].[SystemUserDefinedFields]
          ([FILEPREFIX],
           [FIELDNAME],
           [TYPE],
           [PROMPT],
           [LENGTH],
           [DECMIAL],
           [FORMAT],
           [INITIALVALUE],
           [CALCINITIALVALUE],
           [OVERRIDEINITIALVALUE],
           [REQUIRED],
           [VALIDATION],
           [LOW],
           [HIGH],
           [SYSTEMFIELD],
           [TOP],
           [LEFT],
           [HEIGHT],
           [WIDTH],
           [FONT],
           [VISIBLE],
           [ENABLED],
           [READONLY],
           [MULTILINE],
           [ACTUALNAME],
           [COMMON],
           [UDFCategory],
           [ISLOCK],
           [SQLStatement])
    SELECT 'CNT:'                                                               AS [FILEPREFIX],
           'PostalCode'                                                         AS [FIELDNAME],
           'System'                                                             AS [TYPE],
           'Postal Code'                                                        AS [PROMPT],
           100                                                                  AS [LENGTH],
           0                                                                    AS [DECMIAL],
           '@s100'                                                              AS [FORMAT],
           ''                                                                   AS [INITIALVALUE],
           'N'                                                                  AS [CALCINITIALVALUE],
           'N'                                                                  AS [OVERRIDEINITIALVALUE],
           'N'                                                                  AS [REQUIRED],
           'N'                                                                  AS [VALIDATION],
           0                                                                    AS [LOW],
           0                                                                    AS [HIGH],
           'N'                                                                  AS [SYSTEMFIELD],
           0                                                                    AS [TOP],
           0                                                                    AS [LEFT],
           0                                                                    AS [HEIGHT],
           0                                                                    AS [WIDTH],
           ''                                                                   AS [FONT],
           'Y'                                                                  AS [VISIBLE],
           'Y'                                                                  AS [ENABLED],
           'N'                                                                  AS [READONLY],
           'N'                                                                  AS [MULTILINE],
           ''                                                                   AS [ACTUALNAME],
           1                                                                    AS [COMMON],
           NULL                                                                 AS [UDFCategory],
           0                                                                    AS [ISLOCK],
           NULL                                                                 AS [SQLStatement]
  END
ELSE
  BEGIN
    UPDATE SUF
       SET [FILEPREFIX]             = 'CNT:',
           [FIELDNAME]              = 'PostalCode',
           [TYPE]                   = 'System',
           [PROMPT]                 = 'Postal Code',
           [LENGTH]                 = 100,
           [DECMIAL]                = 0,
           [FORMAT]                 = '@s100',
           [INITIALVALUE]           = '',
           [CALCINITIALVALUE]       = 'N',
           [OVERRIDEINITIALVALUE]   = 'N',
           [REQUIRED]               = 'N',
           [VALIDATION]             = 'N',
           [LOW]                    = 0,
           [HIGH]                   = 0,
           [SYSTEMFIELD]            = 'N',
           [TOP]                    = 0,
           [LEFT]                   = 0,
           [HEIGHT]                 = 0,
           [WIDTH]                  = 0,
           [FONT]                   = '',
           [VISIBLE]                = 'Y',
           [ENABLED]                = 'Y',
           [READONLY]               = 'N',
           [MULTILINE]              = 'N',
           [ACTUALNAME]             = '',
           [COMMON]                 = 1,
           [UDFCategory]            = NULL,
           [ISLOCK]                 = 0,
           [SQLStatement]           = NULL
      FROM [dbo].[SystemUserDefinedFields] SUF
     WHERE SUF.[FILEPREFIX] = 'CNT:'
       AND SUF.[FIELDNAME] = 'PostalCode'
       AND SUF.[PROMPT] <> 'Postal Code'
  END
GO

IF NOT EXISTS
  (SELECT TOP 1 1
     FROM [dbo].[SystemUserDefinedFields] SUF
    WHERE SUF.[FILEPREFIX] = 'LCN:'
      AND SUF.[FIELDNAME] = 'PostalCode')
  BEGIN
    INSERT
      INTO [dbo].[SystemUserDefinedFields]
          ([FILEPREFIX],
           [FIELDNAME],
           [TYPE],
           [PROMPT],
           [LENGTH],
           [DECMIAL],
           [FORMAT],
           [INITIALVALUE],
           [CALCINITIALVALUE],
           [OVERRIDEINITIALVALUE],
           [REQUIRED],
           [VALIDATION],
           [LOW],
           [HIGH],
           [SYSTEMFIELD],
           [TOP],
           [LEFT],
           [HEIGHT],
           [WIDTH],
           [FONT],
           [VISIBLE],
           [ENABLED],
           [READONLY],
           [MULTILINE],
           [ACTUALNAME],
           [COMMON],
           [UDFCategory],
           [ISLOCK],
           [SQLStatement])
    SELECT 'LCN:'                                                               AS [FILEPREFIX],
           'PostalCode'                                                         AS [FIELDNAME],
           'System'                                                             AS [TYPE],
           'Postal Code'                                                        AS [PROMPT],
           100                                                                  AS [LENGTH],
           0                                                                    AS [DECMIAL],
           '@s100'                                                              AS [FORMAT],
           ''                                                                   AS [INITIALVALUE],
           'N'                                                                  AS [CALCINITIALVALUE],
           'N'                                                                  AS [OVERRIDEINITIALVALUE],
           'N'                                                                  AS [REQUIRED],
           'N'                                                                  AS [VALIDATION],
           0                                                                    AS [LOW],
           0                                                                    AS [HIGH],
           'N'                                                                  AS [SYSTEMFIELD],
           0                                                                    AS [TOP],
           0                                                                    AS [LEFT],
           0                                                                    AS [HEIGHT],
           0                                                                    AS [WIDTH],
           ''                                                                   AS [FONT],
           'Y'                                                                  AS [VISIBLE],
           'Y'                                                                  AS [ENABLED],
           'N'                                                                  AS [READONLY],
           'N'                                                                  AS [MULTILINE],
           ''                                                                   AS [ACTUALNAME],
           1                                                                    AS [COMMON],
           NULL                                                                 AS [UDFCategory],
           0                                                                    AS [ISLOCK],
           NULL                                                                 AS [SQLStatement]
  END
ELSE
  BEGIN
    UPDATE SUF
       SET [FILEPREFIX]             = 'LCN:',
           [FIELDNAME]              = 'PostalCode',
           [TYPE]                   = 'System',
           [PROMPT]                 = 'Postal Code',
           [LENGTH]                 = 100,
           [DECMIAL]                = 0,
           [FORMAT]                 = '@s100',
           [INITIALVALUE]           = '',
           [CALCINITIALVALUE]       = 'N',
           [OVERRIDEINITIALVALUE]   = 'N',
           [REQUIRED]               = 'N',
           [VALIDATION]             = 'N',
           [LOW]                    = 0,
           [HIGH]                   = 0,
           [SYSTEMFIELD]            = 'N',
           [TOP]                    = 0,
           [LEFT]                   = 0,
           [HEIGHT]                 = 0,
           [WIDTH]                  = 0,
           [FONT]                   = '',
           [VISIBLE]                = 'Y',
           [ENABLED]                = 'Y',
           [READONLY]               = 'N',
           [MULTILINE]              = 'N',
           [ACTUALNAME]             = '',
           [COMMON]                 = 1,
           [UDFCategory]            = NULL,
           [ISLOCK]                 = 0,
           [SQLStatement]           = NULL
      FROM [dbo].[SystemUserDefinedFields] SUF
     WHERE SUF.[FILEPREFIX] = 'LCN:'
       AND SUF.[FIELDNAME] = 'PostalCode'
       AND SUF.[PROMPT] <> 'Postal Code'
  END
GO

IF NOT EXISTS
  (SELECT TOP 1 1
     FROM [dbo].[SystemUserDefinedFields] SUF
    WHERE SUF.[FILEPREFIX] = 'MAT:'
      AND SUF.[FIELDNAME] = 'BranchPostalCode')
  BEGIN
    INSERT
      INTO [dbo].[SystemUserDefinedFields]
          ([FILEPREFIX],
           [FIELDNAME],
           [TYPE],
           [PROMPT],
           [LENGTH],
           [DECMIAL],
           [FORMAT],
           [INITIALVALUE],
           [CALCINITIALVALUE],
           [OVERRIDEINITIALVALUE],
           [REQUIRED],
           [VALIDATION],
           [LOW],
           [HIGH],
           [SYSTEMFIELD],
           [TOP],
           [LEFT],
           [HEIGHT],
           [WIDTH],
           [FONT],
           [VISIBLE],
           [ENABLED],
           [READONLY],
           [MULTILINE],
           [ACTUALNAME],
           [COMMON],
           [UDFCategory],
           [ISLOCK],
           [SQLStatement])
    SELECT 'MAT:'                                                               AS [FILEPREFIX],
           'BranchPostalCode'                                                   AS [FIELDNAME],
           'System'                                                             AS [TYPE],
           'Branch Postal Code'                                                 AS [PROMPT],
           100                                                                  AS [LENGTH],
           0                                                                    AS [DECMIAL],
           '@s100'                                                              AS [FORMAT],
           ''                                                                   AS [INITIALVALUE],
           'N'                                                                  AS [CALCINITIALVALUE],
           'N'                                                                  AS [OVERRIDEINITIALVALUE],
           'N'                                                                  AS [REQUIRED],
           'N'                                                                  AS [VALIDATION],
           0                                                                    AS [LOW],
           0                                                                    AS [HIGH],
           'N'                                                                  AS [SYSTEMFIELD],
           0                                                                    AS [TOP],
           0                                                                    AS [LEFT],
           0                                                                    AS [HEIGHT],
           0                                                                    AS [WIDTH],
           ''                                                                   AS [FONT],
           'Y'                                                                  AS [VISIBLE],
           'Y'                                                                  AS [ENABLED],
           'N'                                                                  AS [READONLY],
           'N'                                                                  AS [MULTILINE],
           'BRC:PostalCode'                                                     AS [ACTUALNAME],
           1                                                                    AS [COMMON],
           NULL                                                                 AS [UDFCategory],
           0                                                                    AS [ISLOCK],
           NULL                                                                 AS [SQLStatement]
  END
ELSE
  BEGIN
    UPDATE SUF
       SET [FILEPREFIX]             = 'MAT:',
           [FIELDNAME]              = 'BranchPostalCode',
           [TYPE]                   = 'System',
           [PROMPT]                 = 'Branch Postal Code',
           [LENGTH]                 = 100,
           [DECMIAL]                = 0,
           [FORMAT]                 = '@s100',
           [INITIALVALUE]           = '',
           [CALCINITIALVALUE]       = 'N',
           [OVERRIDEINITIALVALUE]   = 'N',
           [REQUIRED]               = 'N',
           [VALIDATION]             = 'N',
           [LOW]                    = 0,
           [HIGH]                   = 0,
           [SYSTEMFIELD]            = 'N',
           [TOP]                    = 0,
           [LEFT]                   = 0,
           [HEIGHT]                 = 0,
           [WIDTH]                  = 0,
           [FONT]                   = '',
           [VISIBLE]                = 'Y',
           [ENABLED]                = 'Y',
           [READONLY]               = 'N',
           [MULTILINE]              = 'N',
           [ACTUALNAME]             = 'BRC:PostalCode',
           [COMMON]                 = 1,
           [UDFCategory]            = NULL,
           [ISLOCK]                 = 0,
           [SQLStatement]           = NULL
      FROM [dbo].[SystemUserDefinedFields] SUF
     WHERE SUF.[FILEPREFIX] = 'MAT:'
       AND SUF.[FIELDNAME] = 'PostalCode'
       AND SUF.[PROMPT] <> 'Branch Postal Code'
  END
GO

-- Correction for CaseAssociatesNames - Should refer to ActualName "NAM:"
UPDATE SUF
   SET SUF.[ACTUALNAME] = 
       CASE WHEN SO.[name] = 'CaseAssociatesContacts'
             AND SC2.[name] IS NOT NULL
                 THEN 'CHOOSE(clip(NAC:' + SC.[name] + ')='''', NAM:' + SC.[name] + ', NAC:' + SC.[name] + ')'
            WHEN SO.[name] = 'CaseAssociatesContacts'
                 THEN 'NAC:' + SC.[name]
            WHEN SO.[name] = 'CaseContacts'
             AND SC2.[name] IS NOT NULL
                 THEN 'CHOOSE(clip(CC:' + SC.[name] + ')='''', NAM:' + SC.[name] + ', CC:' + SC.[name] + ')'
            WHEN SO.[name] = 'CaseContacts'
                 THEN 'CC:' + SC.[name]
            ELSE 'NAM:' + SC.[name] END
  FROM SYS.[objects] SO
       INNER JOIN SYS.[columns] SC
                  INNER JOIN SYS.[types] ST
                          ON ST.[system_type_id] = SC.[system_type_id]
               ON SC.[object_id] = SO.[object_id]
       LEFT OUTER JOIN [dbo].[SystemUserDefinedFields] SUF
                    ON SUF.[FILEPREFIX] = 'CAN:'
                   AND (   (    SO.[name] <> 'CaseAssociatesContacts'
                            AND SUF.[FIELDNAME] = SC.[name])
                        OR (    SO.[name] = 'CaseAssociatesContacts'
                            AND SUF.[FIELDNAME] = 'Assign' + SC.[name]))
       LEFT OUTER JOIN SYS.[objects] SO2
                    ON SO2.[name] = 'CaseAssociatesNames'
                   AND SO2.[type] = 'U'
       LEFT OUTER JOIN SYS.[columns] SC2
                    ON SC2.[object_id] = SO2.[object_id]
                   AND SC2.[name] = SC.[name]
       OUTER APPLY (SELECT TOP 1 SUF2.[PROMPT]
                      FROM [dbo].[SystemUserDefinedFields] SUF2
                     WHERE SUF2.[FieldName] = SC.[name]) SUP
 WHERE SO.[name] = 'CaseAssociatesNames'
   AND SUF.[ACTUALNAME] = ''
GO

-- Correction for CaseContacts - ActualName should not start with CC:
UPDATE SUF
   SET SUF.[ACTUALNAME] = ''
  FROM SYS.[objects] SO
       INNER JOIN SYS.[columns] SC
                  INNER JOIN SYS.[types] ST
                          ON ST.[system_type_id] = SC.[system_type_id]
               ON SC.[object_id] = SO.[object_id]
       LEFT OUTER JOIN [dbo].[SystemUserDefinedFields] SUF
                    ON SUF.[FILEPREFIX] = 'CAN:'
                   AND (   (    SO.[name] <> 'CaseAssociatesContacts'
                            AND SUF.[FIELDNAME] = SC.[name])
                        OR (    SO.[name] = 'CaseAssociatesContacts'
                            AND SUF.[FIELDNAME] = 'Assign' + SC.[name]))
       LEFT OUTER JOIN SYS.[objects] SO2
                    ON SO2.[name] = 'CaseAssociatesNames'
                   AND SO2.[type] = 'U'
       LEFT OUTER JOIN SYS.[columns] SC2
                    ON SC2.[object_id] = SO2.[object_id]
                   AND SC2.[name] = SC.[name]
       OUTER APPLY (SELECT TOP 1 SUF2.[PROMPT]
                      FROM [dbo].[SystemUserDefinedFields] SUF2
                     WHERE SUF2.[FieldName] = SC.[name]) SUP
       LEFT OUTER JOIN [dbo].[SystemUserDefinedFieldsBackupB52267] SUFOLD
                    ON SUFOLD.[FILEPREFIX] = SUF.[FILEPREFIX]
                   AND SUFOLD.[FIELDNAME] = SUF.[FIELDNAME]
 WHERE SO.[name] = 'CaseContacts'
   AND SUF.[ACTUALNAME] LIKE 'CC:%'
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.2.69
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.2.74
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 74, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.2.2.74'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
IF EXISTS(
	SELECT TOP 1 1 FROM SYS.objects obj
		INNER JOIN SYS.columns Col on Col.object_id = obj.object_id 
	WHERE
		OBJ.name='Templates' AND col.name = 'Retired')
BEGIN
	UPDATE Templates SET Retired = 'N' WHERE  Retired IS NULL
END
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.2.74
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.2.75
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 75, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.2.2.75'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
IF EXISTS(
	SELECT TOP 1 1 FROM SYS.objects obj
		INNER JOIN SYS.columns Col on Col.object_id = obj.object_id 
	WHERE
		OBJ.name='ModuleGroup')
BEGIN
	IF NOT EXISTS(SELECT TOP 1 1 FROM ModuleGroup WHERE GroupName = 'All Handler')
	BEGIN
		INSERT INTO ModuleGroup ([GroupName], [Description], [IsActive] )
		VALUES('All Handler','All Handler',0)
	END
END
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.2.75
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.2.79
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 79, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.2.2.79'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
IF EXISTS(
	SELECT TOP 1 1  FROM sys.objects obj
	INNER JOIN sys.columns Col on Col.object_id = obj.object_id 
	WHERE OBJ.name = 'StatusCodes' AND col.name = 'Retired'
)
BEGIN
	UPDATE StatusCodes SET Retired = 'N' WHERE Retired is null
END
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.2.79
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.2.84
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 84, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.2.2.84'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
DECLARE @BILLHEADER NVARCHAR(20)
DECLARE @USER NVARCHAR(10)

DECLARE @NCOMMAND NVARCHAR(MAX)

IF [dbo].[ISSAM4]() = 0
  BEGIN
    SET @BILLHEADER = N'BILLHEADER'
    SET @USER = N'USER'
  END
ELSE
  BEGIN
    SET @BILLHEADER = N'BILLHEAD'
    SET @USER = N'CreateBy'
  END

SET @NCOMMAND = N'UPDATE BH
   SET BH.[' + @USER + N'] = HLO.[CODE]
  FROM [dbo].[' + @BILLHEADER + N'] BH
       LEFT OUTER JOIN [dbo].[Handlers] HAN
                    ON HAN.[CODE] = BH.[' + @USER + N']
       LEFT OUTER JOIN [dbo].[Handlers] HLO
                    ON HLO.[LOGON] = BH.[' + @USER + N']
 WHERE HAN.[CODE] IS NULL
   AND HLO.[CODE] IS NOT NULL

UPDATE BH
   SET BH.[' + @USER + N'] = HL2.[CODE]
  FROM [dbo].[' + @BILLHEADER + N'] BH
       LEFT OUTER JOIN [dbo].[Handlers] HAN
                    ON HAN.[CODE] = BH.[' + @USER + N']
       LEFT OUTER JOIN [dbo].[Handlers] HLO
                    ON HLO.[LOGON] = BH.[' + @USER + N']
       LEFT OUTER JOIN [dbo].[Handlers] HL2
                    ON SUBSTRING(HL2.[LOGON], 1, 8) = SUBSTRING(BH.[' + @USER + N'], 1, 8)
 WHERE HAN.[CODE] IS NULL
   AND HLO.[CODE] IS NULL
   AND HL2.[CODE] IS NOT NULL

UPDATE BH
   SET BH.[' + @USER + N'] = HLN.[CODE]
  FROM [dbo].[' + @BILLHEADER + N'] BH
       LEFT OUTER JOIN [dbo].[Handlers] HAN
                    ON HAN.[CODE] = BH.[' + @USER + N']
       LEFT OUTER JOIN [dbo].[Handlers] HLO
                    ON HLO.[LOGON] = BH.[' + @USER + N']
       LEFT OUTER JOIN [dbo].[Handlers] HL2
                    ON SUBSTRING(HL2.[LOGON], 1, 8) = SUBSTRING(BH.[' + @USER + N'], 1, 8)
       OUTER APPLY (SELECT TOP 1 HL3.[CODE]
                      FROM [dbo].[Handlers] HL3
                     WHERE HL3.[NAME] LIKE ''%'' + RTRIM(LTRIM(ISNULL(BH.[' + @USER + N'], ''''))) + ''%'') HLN
 WHERE HAN.[CODE] IS NULL
   AND HLO.[CODE] IS NULL
   AND HL2.[CODE] IS NULL
   AND RTRIM(ISNULL(BH.[' + @USER + N'], '''')) <> ''''

UPDATE BH
   SET BH.[' + @USER + N'] = ADM.[CODE]
  FROM [dbo].[' + @BILLHEADER + N'] BH
       LEFT OUTER JOIN [dbo].[Handlers] HAN
                    ON HAN.[CODE] = BH.[' + @USER + N']
       LEFT OUTER JOIN [dbo].[Handlers] ADM
                    ON ADM.[CODE] = ''ADM''
 WHERE HAN.[CODE] IS NULL'

EXEC sp_executesql @NCOMMAND
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.2.84
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.2.89
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 89, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.2.2.89'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
/****************************************************************************
 *
 * Having created triggers to deal with diary deletions and diary attachment
 * deletions, we should now get rid of orphaned data
 *
 * START
 *
 ****************************************************************************/
BEGIN TRY
DECLARE @TRS TABLE
       ([id]              INT    IDENTITY(1, 1),
        [TrackReference]  INT)

DECLARE @BS TABLE
       ([id]              INT    IDENTITY(1, 1),
        [SectionID]       INT)

DECLARE @NEWORDER TABLE
       ([id]              INT    IDENTITY(1, 1),
        [SortOrder]       INT)

INSERT
  INTO @TRS
      ([TrackReference])
SELECT DISTINCT
       BD.[TrackReference]
  FROM [dbo].[BriefDocuments] BD
       LEFT OUTER JOIN [dbo].[DiaryAttachments] DAT
                    ON DAT.[TrackReference] = BD.[TrackReference]
 WHERE DAT.[TrackReference] IS NULL

DECLARE @TR INT
DECLARE @ID INT
DECLARE @SectionID INT
DECLARE @SID INT

SELECT TOP 1
       @ID = TRS.[id],
       @TR = TRS.[TRACKREFERENCE]
  FROM @TRS TRS

WHILE @ID IS NOT NULL
  BEGIN
    DELETE @TRS WHERE [id] = @ID

    DELETE @BS

    INSERT
      INTO @BS
          ([SectionID])
    SELECT DISTINCT
           [SectionID]
      FROM [dbo].[BriefDocuments] BD
     WHERE BD.[TrackReference] = @TR

    DELETE BD
      FROM [dbo].[BriefDocuments] BD
     WHERE BD.[TrackReference] = @TR

    SET @SID = NULL
    
    SELECT TOP 1
           @SID = BS.[id],
           @SectionID = BS.[SectionID]
      FROM @BS BS

    WHILE @SID IS NOT NULL
      BEGIN
        DELETE @NEWORDER

        INSERT
          INTO @NEWORDER
              ([SortOrder])
          SELECT BD.[SortOrder]
            FROM [dbo].[BriefDocuments] BD
           WHERE BD.[SectionID] = @SectionID
        ORDER BY BD.[SortOrder]

        UPDATE BD
           SET BD.[SortOrder] = NOR.[id]
          FROM @NEWORDER NOR
               INNER JOIN [dbo].[BriefDocuments] BD
                       ON BD.[SectionID] = @SectionID
                      AND BD.[SortOrder] = NOR.[SortOrder]

        DELETE @BS WHERE [id] = @SID
                
        SET @SID = NULL
    
        SELECT TOP 1
               @SID = BS.[id],
               @SectionID = BS.[SectionID]
          FROM @BS BS
      END

    SET @ID = NULL

    SELECT TOP 1
           @ID = TRS.[id],
           @TR = TRS.[TRACKREFERENCE]
      FROM @TRS TRS
  END

END TRY
BEGIN CATCH
END CATCH
GO

DELETE OLA
  FROM [dbo].[OLApptXref] OLA
       LEFT OUTER JOIN [dbo].[diary] DIA
                    ON DIA.[ACTIONID] = OLA.[ACTIONID]
 WHERE DIA.[ACTIONID] is null
GO

DELETE DTM
  FROM [dbo].[diarytemp] DTM
       LEFT OUTER JOIN [dbo].[diary] DIA
                    ON DIA.[ACTIONID] = DTM.[ACTIONID]
 WHERE DIA.[ACTIONID] is null
GO

DELETE DLK
  FROM [dbo].[DiaryLinks] DLK
       LEFT OUTER JOIN [dbo].[diary] DIA
                    ON DIA.[ACTIONID] = DLK.[ACTIONID]
 WHERE DIA.[ACTIONID] is null
GO

DELETE DLG
  FROM [dbo].[DiaryDelegations] DLG
       LEFT OUTER JOIN [dbo].[diary] DIA
                    ON DIA.[ACTIONID] = DLG.[ACTIONID]
 WHERE DIA.[ACTIONID] is null
GO

DELETE DAV
  FROM [dbo].[DiaryAttachmentVersioning] DAV
       LEFT OUTER JOIN [dbo].[DiaryAttachments] DAT
                    ON DAT.[TrackReference] = DAV.[TrackReference]
 WHERE DAT.[TrackReference] is null
GO

DELETE DII
  FROM [dbo].[DAIndexInfo] DII
       LEFT OUTER JOIN [dbo].[DiaryAttachments] DAT
                    ON DAT.[TrackReference] = DII.[TrackReference]
 WHERE DAT.[TrackReference] is null
GO

DELETE H
  FROM [dbo].[MessageHashXRef] H
       LEFT OUTER JOIN [dbo].[DiaryAttachments] DAT
                    ON DAT.[TrackReference] = H.[TrackReference]
 WHERE DAT.[TrackReference] is null
GO

BEGIN TRY
UPDATE RIS
   SET RIS.[STATUS] = 4
  FROM [dbo].[ReindexStatus] RIS
       LEFT OUTER JOIN [dbo].[DiaryAttachments] DAT
                    ON DAT.[TRACKREFERENCE] = RIS.[TrackReference]
 WHERE DAT.[TrackReference] IS NULL
   AND RIS.[STATUS] <> 4
END TRY
BEGIN CATCH
END CATCH
GO

DELETE DAX
  FROM [dbo].[DiaryAttachmentText] DAX
       LEFT OUTER JOIN [dbo].[DiaryAttachments] DAT
                    ON DAT.[TrackReference] = DAX.[TrackReference]
 WHERE DAT.[TrackReference] is null
GO

BEGIN TRY
  INSERT
    INTO [dbo].[DAIMXRefRetired]
        ([TrackReference],
         [IMDocID],
         [FILEPATH])
  SELECT XR.[TrackReference],
         XR.[IMDocID],
         XR.[FILEPATH]
    FROM [dbo].[DAIMXRef] XR
         LEFT OUTER JOIN [dbo].[DiaryAttachments] DAT
                      ON DAT.[TRACKREFERENCE] = XR.[TrackReference]
   WHERE DAT.[TrackReference] IS NULL
     AND ISNULL(XR.[TrackReference], 0) <> 0
END TRY
BEGIN CATCH
END CATCH

BEGIN TRY
  DELETE XR
    FROM [dbo].[DAIMXRef] XR
         LEFT OUTER JOIN [dbo].[DiaryAttachments] DAT
                      ON DAT.[TRACKREFERENCE] = XR.[TrackReference]
   WHERE DAT.[TrackReference] IS NULL
     AND ISNULL(XR.[TrackReference], 0) <> 0
END TRY
BEGIN CATCH
END CATCH
GO

DELETE DAT
  FROM [dbo].[DiaryAttachments] DAT
       LEFT OUTER JOIN [dbo].[diary] DIA
                    ON DIA.[ACTIONID] = DAT.[DiaryID]
 WHERE DIA.[ACTIONID] IS NULL
GO
/****************************************************************************
 *
 * Having created triggers to deal with diary deletions and diary attachment
 * deletions, we should now get rid of orphaned data
 *
 * END
 *
 ****************************************************************************/
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.2.89
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.2.91
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 91, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.2.2.91'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
DELETE DIA FROM [dbo].[diary] DIA WHERE RTRIM(ISNULL([CASECODE], '')) = ''

DELETE CSM FROM [dbo].[CaseMaster] CSM WHERE RTRIM(ISNULL(CSM.[CSCODE], '')) = ''
DELETE MAT FROM [dbo].[matters] MAT WHERE RTRIM(ISNULL(MAT.[Code], '')) = ''

DELETE CLT from [dbo].[client] CLT WHERE RTRIM(ISNULL(CLT.[CLCODE], '')) = ''
DELETE CNT FROM [dbo].[Contacts] CNT WHERE RTRIM(ISNULL(CNT.[Code], '')) = ''
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.2.2.91
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
--Keep this to be safe START
SET NOCOUNT ON
UPDATE #SCRIPT SET [MajorVersion] = 5,
                   [MinorVersion] = 4,
                   [Build] = 1,
                   [Revision] = 1,
                   [CompatibleVersion] = 'Build 5.4.1.1'
SET NOCOUNT OFF
--Keep this to be safe END
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.1.3
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 3, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.4.1.3'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/

-- make sure that the LastMatter and OpenMatters columns in the contacts table
-- reflect the true data in the database
UPDATE CTC
   SET CTC.[LastMatter] = ISNULL(MTX.[LastMatter], 0),
       CTC.[OpenMatters] = ISNULL(MTX.[OpenMatters], 0)
  FROM [dbo].[contacts] CTC
       LEFT OUTER JOIN (  SELECT MAT.[ClientCode],
                                 ISNULL(MAX(CASE WHEN ISNUMERIC(MAT.[Matter]) = 0
                                                      THEN 0
                                                 ELSE CONVERT(INT, MAT.[Matter]) END), 0) AS [LastMatter],
                                 ISNULL(SUM(CASE WHEN ISNULL(MAT.[Closed], 'N') = 'Y'
                                                      THEN 0
                                                 ELSE 1 END), 0) AS [OpenMatters]
                            FROM [dbo].[matters] MAT
                        GROUP BY MAT.[ClientCode]) MTX
                    ON MTX.[ClientCode] = CTC.[Code]
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.1.3
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.1.12
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 12, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.4.1.12'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
IF EXISTS
  (SELECT TOP 1 1
     FROM [dbo].[AssociateTypes] AST
    WHERE RTRIM(ISNULL(AST.[CODE], '')) = '')
  BEGIN
    DECLARE @WHA VARCHAR(12)

    SELECT TOP 1 @WHA = CONVERT(VARCHAR(12), RTRIM(ISNULL(AST.[DESCRIPTION], '')))
      FROM [dbo].[AssociateTypes] AST
     WHERE RTRIM(ISNULL(AST.[CODE], '')) = ''
       AND RTRIM(ISNULL(AST.[DESCRIPTION], '')) <> ''

    IF (@WHA IS NULL)
      BEGIN
        DELETE AST
          FROM [dbo].[AssociateTypes] AST
         WHERE RTRIM(ISNULL(AST.[CODE], '')) = ''
      END

    IF (@WHA IS NOT NULL)
      BEGIN
        DELETE AST
          FROM [dbo].[AssociateTypes] AST
         WHERE RTRIM(ISNULL(AST.[CODE], '')) = ''
           AND CONVERT(VARCHAR(12), RTRIM(ISNULL(AST.[DESCRIPTION], ''))) <> @WHA

        UPDATE AST
           SET AST.[CODE] = CONVERT(VARCHAR(12), RTRIM(ISNULL(AST.[DESCRIPTION], '')))
          FROM [dbo].[AssociateTypes] AST
         WHERE RTRIM(ISNULL(AST.[CODE], '')) = ''
           AND CONVERT(VARCHAR(12), RTRIM(ISNULL(AST.[DESCRIPTION], ''))) = @WHA

        UPDATE CAN
           SET CAN.[TYPE] = @WHA
          FROM [dbo].[CaseAssociatesNames] CAN
         WHERE RTRIM(ISNULL(CAN.[TYPE], '')) = ''
      END
  END

UPDATE CANU
   SET CANU.[TYPE] = RTRIM(ISNULL(AT2.[CODE], ''))
  FROM (SELECT CAN.[CODE],
               CAN.[TYPE]
          FROM [dbo].[CaseAssociatesNames] CAN
               LEFT OUTER JOIN [dbo].[AssociateTypes] AT1
                            ON AT1.[CODE] = CAN.[TYPE]
         WHERE AT1.[CODE] IS NULL) MIS
       LEFT OUTER JOIN [dbo].[AssociateTypes] AT2
                    ON REPLACE(MIS.[TYPE], 's', '') = REPLACE(AT2.[CODE], 's', '')
                   AND RTRIM(ISNULL(AT2.[CODE], '')) <> ''
       INNER JOIN [dbo].[CaseAssociatesNames] CANU
               ON CANU.[CODE] = MIS.[CODE]
 WHERE AT2.[CODE] IS NOT NULL

UPDATE CANU
   SET CANU.[TYPE] = RTRIM(ISNULL(AT3.[CODE], ''))
  FROM (SELECT CAN.[CODE],
               CAN.[TYPE]
          FROM [dbo].[CaseAssociatesNames] CAN
               LEFT OUTER JOIN [dbo].[AssociateTypes] AT1
                            ON AT1.[CODE] = CAN.[TYPE]
         WHERE AT1.[CODE] IS NULL) MIS
       LEFT OUTER JOIN [dbo].[AssociateTypes] AT2
                    ON REPLACE(MIS.[TYPE], 's', '') = REPLACE(AT2.[CODE], 's', '')
                   AND RTRIM(ISNULL(AT2.[CODE], '')) <> ''
       LEFT OUTER JOIN [dbo].[AssociateTypes] AT3
                    ON REPLACE(MIS.[TYPE], 's', '') = REPLACE(AT3.[DESCRIPTION], 's', '')
                   AND RTRIM(ISNULL(AT3.[DESCRIPTION], '')) <> ''
       INNER JOIN [dbo].[CaseAssociatesNames] CANU
               ON CANU.[CODE] = MIS.[CODE]
 WHERE AT2.[CODE] IS NULL
   AND RTRIM(ISNULL(AT3.[CODE], '')) <> ''

INSERT
  INTO [dbo].[AssociateTypes]
      ([CODE],
       [DESCRIPTION],
       [ASSOCIATETYPE])
SELECT DISTINCT
       RTRIM(CONVERT(VARCHAR(12), ISNULL(MIS.[TYPE], ''))),
       RTRIM(CONVERT(VARCHAR(12), ISNULL(MIS.[TYPE], ''))),
       ''
  FROM (SELECT CAN.[CODE],
               CAN.[TYPE]
          FROM [dbo].[CaseAssociatesNames] CAN
               LEFT OUTER JOIN [dbo].[AssociateTypes] AT1
                            ON AT1.[CODE] = CAN.[TYPE]
         WHERE AT1.[CODE] IS NULL) MIS
       LEFT OUTER JOIN [dbo].[AssociateTypes] AT2
                    ON REPLACE(MIS.[TYPE], 's', '') = REPLACE(AT2.[CODE], 's', '')
                   AND RTRIM(ISNULL(AT2.[CODE], '')) <> ''
       LEFT OUTER JOIN [dbo].[AssociateTypes] AT3
                    ON REPLACE(MIS.[TYPE], 's', '') = REPLACE(AT3.[DESCRIPTION], 's', '')
                   AND RTRIM(ISNULL(AT3.[DESCRIPTION], '')) <> ''
 WHERE AT2.[CODE] IS NULL
   AND AT3.[CODE] IS NULL

 UPDATE CAN
    SET CAN.[TYPE] = RTRIM(ISNULL(AT.[CODE], ''))
   FROM [dbo].[CaseAssociatesNames] CAN
        LEFT OUTER JOIN [dbo].[AssociateTypes] AT
                     ON AT.[CODE] = CAN.[TYPE]
  WHERE AT.[CODE] IS NOT NULL

DELETE [dbo].[AssociateTypes] WHERE RTRIM(ISNULL([CODE], '')) = ''

IF EXISTS
  (SELECT TOP 1 1
     FROM [dbo].[CaseAssociatesNames] CAN
    WHERE RTRIM(ISNULL(CAN.[TYPE], '')) = '')
  BEGIN
    INSERT
      INTO [dbo].[AssociateTypes]
          ([CODE],
           [DESCRIPTION],
           [ASSOCIATETYPE])
    VALUES('UNK',
           'Not specified',
           '')

    UPDATE CAN
       SET CAN.[TYPE] = 'UNK'
      FROM [dbo].[CaseAssociatesNames] CAN
           LEFT OUTER JOIN [dbo].[AssociateTypes] AT
                        ON AT.[CODE] = CAN.[TYPE]
     WHERE AT.[CODE] IS NULL
  END

GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.1.12
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.1.24
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 24, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.4.1.24'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
INSERT
  INTO [dbo].[TemplateActions]
      ([ACTIONCODE],
       [DESC],
       [WKTCODE],
       [ACTTYPE],
       [ACTIONCATEGORY],
       [STATUS],
       [PROCESSTYPE],
       [PUBLISHER],
       [UPDATEFIELD],
       [UPDATEVALUE],
       [HIGHLIGHTED],
       [MILESTONETYPE],
       [PRIORITY],
       [NEXTACTIONOPTIONAL],
       [BILLABLE],
       [EMAIL],
       [BILLDESCRIPTION],
       [AssignActionTo],
       [ASSIGNHANDLER],
       [AssignTeamActionTo],
       [ASSIGNTEAM],
       [Description])
SELECT NW.[ACTIONCODE],
       NW.[DESC],
       NW.[WKTCODE],
       NW.[ACTTYPE],
       NW.[ACTIONCATEGORY],
       NW.[STATUS],
       NW.[PROCESSTYPE],
       NW.[PUBLISHER],
       NW.[UPDATEFIELD],
       NW.[UPDATEVALUE],
       NW.[HIGHLIGHTED],
       NW.[MILESTONETYPE],
       NW.[PRIORITY],
       NW.[NEXTACTIONOPTIONAL],
       NW.[BILLABLE],
       NW.[EMAIL],
       NW.[BILLDESCRIPTION],
       NW.[AssignActionTo],
       NW.[ASSIGNHANDLER],
       NW.[AssignTeamActionTo],
       NW.[ASSIGNTEAM],
       NW.[Description]
  FROM (SELECT 'ADMAT' AS [ACTIONCODE],
               'Accountable Trust Receipt' AS [DESC],
               'SYS' AS [WKTCODE],
               'A' AS [ACTTYPE],
               'A' AS [ACTIONCATEGORY],
               'NA' AS [STATUS],
               'I' AS [PROCESSTYPE],
               'N' AS [PUBLISHER],
               '' AS [UPDATEFIELD],
               '' AS [UPDATEVALUE],
               'N' AS [HIGHLIGHTED],
               '' AS [MILESTONETYPE],
               'Normal' AS [PRIORITY],
               'Y' AS [NEXTACTIONOPTIONAL],
               'N' AS [BILLABLE],
               '' AS [EMAIL],
               '' AS [BILLDESCRIPTION],
               'L' AS [AssignActionTo],
               '' AS [ASSIGNHANDLER],
               'L' AS [AssignTeamActionTo],
               '' AS [ASSIGNTEAM],
               'Accountable Trust Receipt' AS [Description]) NW
       LEFT OUTER JOIN [dbo].[TemplateActions] TAC
                    ON TAC.[ACTIONCODE] = NW.[ACTIONCODE]
 WHERE TAC.[ACTIONCODE] IS NULL

GO

-- Strong Room File Manager page was named "TemplateLibrary" in code.
-- Please make sure page names are intuitive. Think of the poor
-- unfortunate soul who may have to support your code after you're gone.
DELETE CTQ
  FROM [dbo].[ControlViews] CTV
       INNER JOIN [dbo].[ControlQueries] CTQ
               ON CTQ.[id] = CTV.[QueryID]
 WHERE (   CTV.[OwnerName] = 'StrongRoomItemEnquiry'
        OR CTV.[OwnerName] = 'StrongRoomFileManager'
        OR CTV.[OwnerName] = 'TemplateLibrary')
   AND CTV.[View] = 'Standard View'
   AND CTV.[ControlSettings] NOT LIKE '%ItemTypeDescription%'

DELETE CTV
  FROM [dbo].[ControlViews] CTV
 WHERE (   CTV.[OwnerName] = 'StrongRoomItemEnquiry'
        OR CTV.[OwnerName] = 'StrongRoomFileManager'
        OR CTV.[OwnerName] = 'TemplateLibrary')
   AND CTV.[View] = 'Standard View'
   AND CTV.[ControlSettings] NOT LIKE '%ItemTypeDescription%'

UPDATE CTQ
   SET CTQ.[OwnerName] = 'StrongRoomFileManager'
  FROM [dbo].[ControlViews] CTV
       INNER JOIN [dbo].[ControlQueries] CTQ
               ON CTQ.[id] = CTV.[QueryID]
 WHERE (   CTV.[OwnerName] = 'StrongRoomItemEnquiry'
        OR CTV.[OwnerName] = 'StrongRoomFileManager'
        OR CTV.[OwnerName] = 'TemplateLibrary')

UPDATE CTV
   SET CTV.[OwnerName] = 'StrongRoomFileManager'
  FROM [dbo].[ControlViews] CTV
 WHERE (   CTV.[OwnerName] = 'StrongRoomItemEnquiry'
        OR CTV.[OwnerName] = 'StrongRoomFileManager'
        OR CTV.[OwnerName] = 'TemplateLibrary')
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.1.24
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.1.25
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 25, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.4.1.25'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
INSERT
  INTO [dbo].[OyezTemplates]
      ([FILEPATH],
       [NAME])
SELECT DISTINCT
       RTRIM(ISNULL(TDC.[FILEPATH], '')),
       [dbo].[ky_NETFNGetDocumentName](TDC.[FILEPATH])
  FROM [dbo].[TemplateDocuments] TDC
       LEFT OUTER JOIN [dbo].[OyezTemplates] OYT
                    ON OYT.[FILEPATH] = RTRIM(ISNULL(TDC.[FILEPATH], ''))
 WHERE (   RTRIM(ISNULL(TDC.[FILEPATH], '')) LIKE '%.OLF'
        OR RTRIM(ISNULL(TDC.[FILEPATH], '')) LIKE '%.OLFX')
   AND OYT.[ID] IS NULL
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.1.25
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.1.43
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 43, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.4.1.43'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
DECLARE @KYCCODES TABLE (
	[TYPE]			VARCHAR(10),
	[DESCRIPTION]	VARCHAR(200)
)

INSERT INTO @KYCCODES (
	[TYPE],
	[DESCRIPTION]
) (
	SELECT 'CLIENT', '' UNION
	SELECT 'CLIENT', 'Residential Private Individual' UNION 
	SELECT 'CLIENT', 'Non Resident Private Individual' UNION 
	SELECT 'CLIENT', 'Corporate Entities' UNION 
	SELECT 'CLIENT', 'Partnerships ' UNION 
	SELECT 'CLIENT', 'Unincorporated businesses' UNION 
	SELECT 'CLIENT', 'Other trusts, foundations and similar entities' UNION 
	SELECT 'CLIENT', 'Clubs and Societies' UNION 
	SELECT 'CLIENT', 'Pension schemes' UNION 
	SELECT 'CLIENT', 'Charities' UNION 
	SELECT 'CLIENT', 'Public sector body' UNION 
	SELECT 'CLIENT', 'State-owned company' UNION 
	SELECT 'CLIENT', 'Supranational Organisation'
)

INSERT INTO @KYCCODES (
	[TYPE],
	[DESCRIPTION]
) (
	SELECT 'INTRO', '' UNION
	SELECT 'INTRO', 'Face to face meeting' UNION 
	SELECT 'INTRO', 'Non face to face meeting by telephone' UNION 
	SELECT 'INTRO', 'Non face to face meeting by post' UNION 
	SELECT 'INTRO', 'Non face to face meeting by email ' UNION 
	SELECT 'INTRO', 'Third Party'
)

INSERT INTO @KYCCODES (
	[TYPE],
	[DESCRIPTION]
) (
	SELECT 'TYPE', '' UNION
	SELECT 'TYPE', 'Standard Due Diligence' UNION 
	SELECT 'TYPE', 'Enhanced Due Diligence' UNION 
	SELECT 'TYPE', 'Simplified Client Due Diligence (SCDD)'
)

INSERT INTO @KYCCODES (
	[TYPE],
	[DESCRIPTION]
) (
	SELECT 'PHOTO', 'Irish Passport ' UNION
	SELECT 'PHOTO', 'International Passport' UNION
	SELECT 'PHOTO', 'Photo card driving licence' UNION
	SELECT 'PHOTO', 'National Identity Card' UNION
	SELECT 'PHOTO', 'Identification form with photo signed by a member of the Garda (ML10)' UNION
	SELECT 'PHOTO', 'Social Welfare card with photo ID' UNION
	SELECT 'PHOTO', 'GNIB card accompanied by letter from Office of Minister for Integration (signed and stamped)'
)

INSERT INTO @KYCCODES (
	[TYPE],
	[DESCRIPTION]
) (
	SELECT 'NONPHOTO', 'Documentation/cards issued by the Revenue Commissioners showing the name of the person and their PPSN' UNION
	SELECT 'NONPHOTO', 'Documentation/cards issued by the Department of Social Protection showing the name of the person and their PPSN' UNION
	SELECT 'NONPHOTO', 'Instrument of a court appointment (such as liquidator, or grant of probate)' UNION
	SELECT 'NONPHOTO', 'Local authority document e.g. refuse collection bill, water charge bill (including those printed from the internet)' UNION
	SELECT 'NONPHOTO', 'Bank statements, or credit/debit card statements, issued by a regulated financial sector designated person in the Ireland, EU or comparable jurisdiction (including those printed from the internet)' UNION
	SELECT 'NONPHOTO', 'Utility bills (including those printed from the internet)' UNION
	SELECT 'NONPHOTO', 'Household insurance certificate and renewal notice' UNION
	SELECT 'NONPHOTO', 'Motor insurance certificate and renewal notice' UNION
	SELECT 'NONPHOTO', 'Medical card for over 18s with intellectual disability'
)

INSERT INTO [dbo].[ClientType] (
	[Description]
) (
	SELECT
		KYC.[DESCRIPTION]
	FROM @KYCCODES AS KYC
	LEFT OUTER JOIN [dbo].[ClientType] AS CLT
	ON LTRIM(RTRIM(CLT.[Description])) = LTRIM(RTRIM(KYC.[DESCRIPTION]))
	WHERE
		[TYPE] = 'CLIENT' AND
		CLT.[Description] IS NULL)

INSERT INTO [dbo].[IntroductionBy] (
	[Description]
) (
	SELECT
		KYC.[DESCRIPTION]
	FROM @KYCCODES AS KYC
	LEFT OUTER JOIN [dbo].[IntroductionBy] AS [INT]
	ON LTRIM(RTRIM([INT].[Description])) = LTRIM(RTRIM(KYC.[DESCRIPTION]))
	WHERE
		[TYPE] = 'INTRO' AND
		[INT].[Description] IS NULL)

INSERT INTO [dbo].[KYCType] (
	[Description]
) (
	SELECT
		KYC.[DESCRIPTION]
	FROM @KYCCODES AS KYC
	LEFT OUTER JOIN [dbo].[KYCType] AS KTY
	ON LTRIM(RTRIM(KTY.[Description])) = LTRIM(RTRIM(KYC.[DESCRIPTION]))
	WHERE
		[TYPE] = 'TYPE' AND
		KTY.[Description] IS NULL)

INSERT INTO [dbo].[IDCodes] (
	[IdCode],
	[Description],
	[Category]
) (
	SELECT
		RIGHT('000' + CONVERT(VARCHAR(3), ((SELECT ISNULL(MAX([IdCode]), 0) FROM [dbo].[IDCodes] WHERE ISNUMERIC([IdCode]) = 1) + ROW_NUMBER() OVER(ORDER BY KYC.[DESCRIPTION] ASC))), 3),
		KYC.[DESCRIPTION],
		'P'
	FROM @KYCCODES AS KYC
	LEFT OUTER JOIN [dbo].[IDCodes] AS IDC
	ON LTRIM(RTRIM(KYC.[DESCRIPTION])) = LTRIM(RTRIM(IDC.[Description]))
	AND ISNULL(IDC.[Category], '') = 'P'
	WHERE
		KYC.[TYPE] = 'PHOTO' AND
		IDC.[Description] IS NULL)

INSERT INTO [dbo].[IDCodes] (
	[IdCode],
	[Description],
	[Category]
) (
	SELECT
		RIGHT('000' + CONVERT(VARCHAR(3), ((SELECT ISNULL(MAX(CONVERT(INT, [IdCode])), 0) FROM [dbo].[IDCodes] WHERE ISNUMERIC([IdCode]) = 1) + ROW_NUMBER() OVER(ORDER BY KYC.[DESCRIPTION] ASC))), 3),
		KYC.[DESCRIPTION],
		'N'
	FROM @KYCCODES AS KYC
	LEFT OUTER JOIN [dbo].[IDCodes] AS IDC
	ON LTRIM(RTRIM(KYC.[DESCRIPTION])) = LTRIM(RTRIM(IDC.[Description]))
	AND ISNULL(IDC.[Category], '') = 'N'
	WHERE
		KYC.[TYPE] = 'NONPHOTO' AND
		IDC.[Description] IS NULL)

GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.1.43
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.1.46
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 46, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.4.1.46'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
 -- Update any contacts which have matters on them to mark them as clients
UPDATE CON SET
	CON.[Client] = CASE WHEN (SELECT TOP 1 COUNT(1) FROM [dbo].[matters] WHERE [ClientCode] = CON.[Code]) > 0 THEN 'Y' ELSE 'N' END
FROM [dbo].[Contacts] AS CON

GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.1.46
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.1.49
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 49, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.4.1.49'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
IF NOT EXISTS
  (SELECT TOP 1 1
     FROM [dbo].[SystemUserDefinedFields] SUF
    WHERE SUF.[FILEPREFIX] = 'DIA:'
      AND SUF.[FIELDNAME] = 'Text2')
BEGIN
INSERT 
  INTO [dbo].[SystemUserDefinedFields]
      ([FILEPREFIX],
       [FIELDNAME],
       [TYPE],
       [PROMPT],
       [LENGTH],
       [DECMIAL],
       [FORMAT],
       [INITIALVALUE],
       [CALCINITIALVALUE],
       [OVERRIDEINITIALVALUE],
       [REQUIRED],
       [VALIDATION],
       [LOW],
       [HIGH],
       [SYSTEMFIELD],
       [TOP],
       [LEFT],
       [HEIGHT],
       [WIDTH],
       [FONT],
       [VISIBLE],
       [ENABLED],
       [READONLY],
       [MULTILINE],
       [ACTUALNAME],
       [COMMON],
       [UDFCategory],
       [ISLOCK],
       [SQLSTATEMENT])
VALUES('DIA:',
       'Text2',
       'System',
       'Text2 Description',
       4000,
       0,
       '',
       '',
       '',
       '',
       '',
       '',
       0.00,
       0.00,
       '',
       0,
       0.00,
       0,
       0.00,
       '',
       '',
       '',
       '',
       '',
       '',
       1,
       NULL,
       0,
       NULL)
END

IF NOT EXISTS
  (SELECT TOP 1 1
     FROM [dbo].[SystemUserDefinedFields] SUF
    WHERE SUF.[FILEPREFIX] = 'DIA:'
      AND SUF.[FIELDNAME] = 'Subject')
BEGIN
INSERT INTO [dbo].[SystemUserDefinedFields]
      ([FILEPREFIX],
       [FIELDNAME],
       [TYPE],
       [PROMPT],
       [LENGTH],
       [DECMIAL],
       [FORMAT],
       [INITIALVALUE],
       [CALCINITIALVALUE],
       [OVERRIDEINITIALVALUE],
       [REQUIRED],
       [VALIDATION],
       [LOW],
       [HIGH],
       [SYSTEMFIELD],
       [TOP],
       [LEFT],
       [HEIGHT],
       [WIDTH],
       [FONT],
       [VISIBLE],
       [ENABLED],
       [READONLY],
       [MULTILINE],
       [ACTUALNAME],
       [COMMON],
       [UDFCategory],
       [ISLOCK],
       [SQLSTATEMENT])
VALUES('DIA:',
       'Subject',
       'System',
       'Text2 Description',
       500,
       0,
       '@S500',
       '',
       'N',
       'N',
       'N',
       'N',
       0.00,
       0.00,
       'N',
       0,
       0.00,
       0,
       0.00,
       '',
       'Y',
       'Y',
       'N',
       'N',
       '',
       1,
       NULL,
       0,
       NULL)
END
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.1.49
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
--Keep this to be safe START
SET NOCOUNT ON
UPDATE #SCRIPT SET [MajorVersion] = 5,
                   [MinorVersion] = 4,
                   [Build] = 2,
                   [Revision] = 1,
                   [CompatibleVersion] = 'Build 5.4.2.1'
SET NOCOUNT OFF
--Keep this to be safe END
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.2.5
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 5, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.4.2.5'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
UPDATE CLT
   SET CLT.[CLEMAIL] = RTRIM(ISNULL(CON.[EMAIL], ''))
  from [dbo].[client] CLT
       INNER JOIN [dbo].[contacts] CON
               ON CON.[CODE] = CLT.[CLCODE]
 WHERE RTRIM(ISNULL(CLT.[CLEMAIL], '')) <> RTRIM(ISNULL(CON.[EMAIL], ''))
   AND RTRIM(ISNULL(CLT.[CLEMAIL], '')) = ''

UPDATE CON
   SET CON.[email] = RTRIM(ISNULL(CLT.[CLEMAIL], ''))
  from [dbo].[client] CLT
       INNER JOIN [dbo].[contacts] CON
               ON CON.[CODE] = CLT.[CLCODE]
 WHERE RTRIM(ISNULL(CLT.[CLEMAIL], '')) <> RTRIM(ISNULL(CON.[EMAIL], ''))
   AND RTRIM(ISNULL(CON.[EMAIL], '')) = ''

UPDATE CLT
   SET CLT.[CLEMAIL] = RTRIM(ISNULL(CON.[EMAIL], ''))
  from [dbo].[client] CLT
       INNER JOIN [dbo].[contacts] CON
               ON CON.[CODE] = CLT.[CLCODE]
 WHERE RTRIM(ISNULL(CLT.[CLEMAIL], '')) <> RTRIM(ISNULL(CON.[EMAIL], ''))
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.2.5
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.2.7
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 7, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.4.2.7'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/

DELETE SEARCHMATTERS
GO
INSERT
  INTO [dbo].[SearchMatters]
      ([Code],
       [ClientCode],
       [Matter],
       [Description],
       [NCDescription],
       [FECode],
       [Partner],
       [Dept],
       [Started],
       [closedate],
       [orgcloseddate],
       [WType],
       [Branch],
       [Closed],
       [User1],
       [User2],
       [User3],
       [YourRef],
       [OldRef],
       [FileNum],
       [FileColour],
       [DeptDescription],
       [WTypeDescription],
       [FileColourDescription],
       [FileBackgroundColour],
       [FileRGBColour],
       [TextColour],
       [HandlerName],
       [NCHandlerName],
       [Team],
       [TeamName],
       [PartnerName],
       [NCPartnerName],
       [Name],
       [NCName],
       [Address],
       [NCAddress],
       [PhoneNumber],
       [email], 
       [Privileges])
SELECT RTRIM(ISNULL(MAT.[Code], '')),
       RTRIM(ISNULL(MAT.[ClientCode], '')),
       RTRIM(ISNULL(MAT.[Matter], '')),
       [dbo].[ky_RemoveSpuriousWhitespace2](MAT.[Description], 200),
       [dbo].[ky_RemoveSpuriousWhitespace2](MAT.[Description], 200) COLLATE SQL_Latin1_General_Cp1251_CS_AS,
       RTRIM(ISNULL(MAT.[FECode], '')),
       RTRIM(ISNULL(MAT.[Partner], '')),
       RTRIM(ISNULL(MAT.[Dept], '')),
       MAT.[Started],
       MAT.[CloseDate],
       MAT.[OrgClosedDate],
       RTRIM(ISNULL(MAT.[WType], '')),
       RTRIM(ISNULL(MAT.[Branch], '')),
       CASE WHEN ISNULL(MAT.[Closed], 'N') = 'Y'
                 THEN CONVERT(BIT, 1)
            ELSE CONVERT(BIT, 0) END,
       RTRIM(ISNULL(MAT.[User1], '')),
       RTRIM(ISNULL(MAT.[User2], '')),
       RTRIM(ISNULL(MAT.[User3], '')),
       RTRIM(ISNULL(MAT.[YourRef], '')),
       RTRIM(ISNULL(MAT.[OldRef], '')),
       ISNULL(MAT.[FileNum], 0),
       RTRIM(ISNULL(MAT.[FileColour], '')),
       RTRIM(ISNULL(DPT.[DESC], '')),
       RTRIM(ISNULL(WKT.[DESC], '')),
       RTRIM(ISNULL(FCL.[COLOURDESC], '')),
       CASE WHEN RTRIM(ISNULL(FCL.[BackgroundColour], '')) = '' THEN 'Transparent' ELSE RTRIM(ISNULL(FCL.[BackgroundColour], '')) END,
       ISNULL(FCL.[RGBColour], -1),
       [dbo].[ky_NETFNGetForegroundColour](ISNULL(FCL.[RGBColour], -1)),
       RTRIM(ISNULL(FEC.[NAME], '')),
       RTRIM(ISNULL(FEC.[NAME], '')) COLLATE SQL_Latin1_General_Cp1251_CS_AS,
       RTRIM(ISNULL(TEA.[CODE], '')),
       RTRIM(ISNULL(TEA.[NAME], '')),
       RTRIM(ISNULL(PAR.[NAME], '')),
       RTRIM(ISNULL(PAR.[NAME], '')) COLLATE SQL_Latin1_General_Cp1251_CS_AS,
       RTRIM(ISNULL(CLT.[CLNAME], '')),
       RTRIM(ISNULL(CLT.[CLNAME], '')) COLLATE SQL_Latin1_General_Cp1251_CS_AS,
       [dbo].[ky_RemoveSpuriousWhitespace2](CLT.[CLADDR], 500),
       [dbo].[ky_RemoveSpuriousWhitespace2](CLT.[CLADDR], 500) COLLATE SQL_Latin1_General_Cp1251_CS_AS,
       RTRIM(ISNULL(CLT.[CLTEL], '')),
       RTRIM(isnull(CLT.CLEMAIL,'')),
       ISNULL(MNP.[Privileges], CONVERT(BIGINT, -1))
  FROM [dbo].[matters] MAT
       LEFT OUTER JOIN [dbo].[Departments] DPT
                    ON DPT.[CODE] = MAT.[Dept]
       LEFT OUTER JOIN [dbo].[WorkTypes] WKT
                    ON WKT.[CODE] = MAT.[WType]
       LEFT OUTER JOIN [dbo].[FileColours] FCL
                    ON FCL.[COLOURCODE] = MAT.[FileColour]
       LEFT OUTER JOIN [dbo].[Handlers] FEC
                       LEFT OUTER JOIN [dbo].[Handlers] TEA
                                    ON TEA.[CODE] = FEC.[TEAM]
                    ON FEC.[CODE] = MAT.[FECode]
       LEFT OUTER JOIN [dbo].[Handlers] PAR
                    ON PAR.[CODE] = MAT.[Partner]
       LEFT OUTER JOIN [dbo].[client] CLT
                    ON CLT.[CLCODE] = MAT.[ClientCode]
       LEFT OUTER JOIN [dbo].[MatterNetPrivileges] MNP
                    ON MNP.[MATTER] = MAT.[Code]


UPDATE SM
   SET SM.[Privileges] = ISNULL(MNP.[Privileges], CONVERT(BIGINT, -1))
  FROM [dbo].[SearchMatters] SM
       LEFT OUTER JOIN [dbo].[MatterNETPrivileges] MNP
                    ON MNP.[MATTER] = SM.[Code]
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.2.7
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.2.16
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 16, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.4.2.16'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
-- KEYD-3381
UPDATE CUF
   SET CUF.[DateValue] = null
  FROM [dbo].[matters] MAT
       INNER JOIN [dbo].[Contacts] CTC
               ON CTC.[Code] = MAT.[ClientCode]
       INNER JOIN [dbo].[CaseUDFAnswers] CUF
                  INNER JOIN [dbo].[SystemUserDefinedFields] SUF
                          ON SUF.[FILEPREFIX] = CUF.[UDFFILE]
                         AND SUF.[FIELDNAME] = CUF.[UDFNAME]
                         AND SUF.[TYPE] = 'date'
               ON CUF.[CASECODE] = MAT.[Code]
 WHERE YEAR(CUF.[DateValue]) = 1900
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.2.16
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.2.18
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 18, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.4.2.18'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
-- Fix missing DischargedBy values. Thankfully we can reconstruct these from
-- the UndertakingLog
-- KEYD-3362
UPDATE UND
   SET UND.[DischargedBy] = HAN.[CODE]
  FROM [dbo].[UndertakingLog] ULG
       LEFT OUTER JOIN [dbo].[Handlers] HAN
                    ON HAN.[NAME] = ULG.[ByWho]
       INNER JOIN [dbo].[Undertakings] UND
               ON UND.[ACTIONID] = ULG.[UndertakingID]
              AND RTRIM(ISNULL(UND.[DischargedBy], '')) = ''
 WHERE ULG.[FieldChanges] LIKE '%has been Discharged'
GO

-- Fix older entries where the DischargedBy column was set to the handler's LOGON
-- rather than their CODE
-- KEYD-3362
UPDATE UND
   SET UND.[DischargedBy] = ISNULL(H2.[CODE], ISNULL(H3.[CODE], UND.[DischargedBy]))
  FROM [dbo].[Undertakings] UND
       LEFT OUTER JOIN [dbo].[Handlers] HAN
                    ON HAN.[CODE] = UND.[DischargedBy]
       OUTER APPLY (SELECT TOP 1 HAN2.[CODE]
                      FROM [dbo].[Handlers] HAN2
                     WHERE HAN2.[LOGON] = UND.[DischargedBy]) H2 --matching LOGON
       OUTER APPLY (SELECT TOP 1 HAN3.[CODE]
                      FROM [dbo].[Handlers] HAN3
                     WHERE RTRIM(ISNULL(UND.[DischargedBy], '')) <> ''
                       AND HAN3.[LOGON] LIKE RTRIM(UND.[DischargedBy]) + '%') H3 --matching LOGON truncated to 8 characters
 WHERE UND.[DischargedBy] <> ''
   AND HAN.[CODE] IS NULL
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.2.18
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.2.20
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 20, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.4.2.20'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
--IF-204 / KEYD-3407
IF NOT EXISTS
  (SELECT TOP 1 1
     FROM [dbo].[ControlQueries]
    WHERE [OwnerName] = 'TasksMain_Team')
  BEGIN
    EXEC ('
SET IDENTITY_INSERT [dbo].[ControlQueries] ON

DECLARE @OldQueries TABLE
       ([id]               INT             IDENTITY(1, 1),
        [oldid]            INT,
        [Handler]          VARCHAR(10),
        [Query]            VARCHAR(200),
        [ControlName]      VARCHAR(50),
        [OwnerName]        VARCHAR(50),
        [Default]          INT,
        [ControlSettings]  VARCHAR(MAX))

INSERT
  INTO @OldQueries
      ([oldid],
       [Handler],
       [Query],
       [ControlName],
       [OwnerName],
       [Default],
       [ControlSettings])
SELECT CTQ.[id],
       CTQ.[Handler],
       CTQ.[Query],
       CTQ.[ControlName],
       CTQ.[OwnerName],
       CTQ.[Default],
       CTQ.[ControlSettings]
  FROM [dbo].[ControlQueries] CTQ
 WHERE CTQ.[OwnerName] = ''TasksMain''

DECLARE @MaxID INT

SELECT @MaxID = ISNULL(MAX(CTQ.[id]), 0)
  FROM [dbo].[ControlQueries] CTQ

INSERT
  INTO [dbo].[ControlQueries]
      ([id],
       [HANDLER],
       [Query],
       [ControlName],
       [OwnerName],
       [Default],
       [ControlSettings])
SELECT @MaxID + CTQ.[id],
       CTQ.[Handler],
       CTQ.[Query],
       CTQ.[ControlName],
       ''TasksMain_Team'',
       CTQ.[Default],
       CTQ.[ControlSettings]
  FROM @OldQueries CTQ

SET IDENTITY_INSERT [dbo].[ControlQueries] OFF

INSERT
  INTO [dbo].[ControlViews]
      ([HANDLER],
       [View],
       [ControlName],
       [OwnerName],
       [Default],
       [ControlSettings],
       [QueryID])
SELECT CTV.[HANDLER],
       CTV.[View],
       CTV.[ControlName],
       ''TasksMain_Team'',
       CTV.[Default],
       CTV.[ControlSettings],
       @MaxID + OLQ.[id]
  FROM [dbo].[ControlViews] CTV
       INNER JOIN @OldQueries OLQ
               ON OLQ.[oldid] = CTV.[QueryID]
 WHERE CTV.[OwnerName] = ''TasksMain''')

    EXEC ('
DECLARE @maxVal INT

SELECT @maxVal = ISNULL(max([id]), 0) + 1
  FROM [dbo].[ControlQueries]

DBCC CHECKIDENT(''ControlQueries'', RESEED, @maxVal)')

    EXEC ('
DECLARE @maxVal INT

SELECT @maxVal = ISNULL(max([id]), 0) + 1
  FROM [dbo].[ControlQueries]

DBCC CHECKIDENT(''ControlQueries'', RESEED, @maxVal)')

    EXEC ('
DECLARE @maxVal INT

SELECT @maxVal = ISNULL(max([id]), 0) + 1
  FROM [dbo].[ControlViews]

DBCC CHECKIDENT(''ControlViews'', RESEED, @maxVal)')

    EXEC ('
DECLARE @maxVal INT

SELECT @maxVal = ISNULL(max([id]), 0) + 1
  FROM [dbo].[ControlViews]

DBCC CHECKIDENT(''ControlViews'', RESEED, @maxVal)')
  END


GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.2.20
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.2.23
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 23, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.4.2.23'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
-- Correct missing Statute Limits dates on matters with uncompleted
-- diary entries of ActionType "S".
UPDATE MAT
   SET MAT.[StatuteLimits] = CONVERT(DATETIME, CONVERT(VARCHAR, MIS.[DUEDATE], 112))
  FROM (  SELECT DIA.[CASECODE],
                 MAX(DIA.[DUEDATE]) AS [DUEDATE] 
            FROM [dbo].[diary] DIA
                 INNER JOIN [dbo].[matters] MTN
                         ON MTN.[Code] = DIA.[CASECODE]
                        AND MTN.[StatuteLimits] IS NULL
           WHERE DIA.[ACTIONTYPE] = 'S'
             AND DIA.[STATUS] = 0
        GROUP BY DIA.[CASECODE]) MIS
       INNER JOIN [dbo].[matters] MAT
               ON MAT.[Code] = MIS.[CASECODE]
 WHERE MIS.[DUEDATE] IS NOT NULL
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.2.23
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.2.27
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 27, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.4.2.27'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
IF NOT EXISTS(SELECT TOP 1 1 FROM Settings where KeyName = 'AutoNumberIfBlank')
BEGIN
INSERT INTO Settings(KeyName,KeyValue) VALUES('AutoNumberIfBlank','False')
END
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.2.27
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.2.40
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 40, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.4.2.40'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
INSERT
  INTO [dbo].[SystemUserDefinedFields]
      ([FILEPREFIX],
       [FIELDNAME],
       [TYPE],
       [PROMPT],
       [LENGTH],
       [DECMIAL],
       [FORMAT],
       [INITIALVALUE],
       [CALCINITIALVALUE],
       [OVERRIDEINITIALVALUE],
       [REQUIRED],
       [VALIDATION],
       [LOW],
       [HIGH],
       [SYSTEMFIELD],
       [TOP],
       [LEFT],
       [HEIGHT],
       [WIDTH],
       [FONT],
       [VISIBLE],
       [ENABLED],
       [READONLY],
       [MULTILINE],
       [ACTUALNAME],
       [COMMON],
       [UDFCategory],
       [ISLOCK],
       [SQLSTATEMENT])
SELECT [NEW].[FILEPREFIX],
       [NEW].[FIELDNAME],
       [NEW].[TYPE],
       [NEW].[PROMPT],
       [NEW].[LENGTH],
       [NEW].[DECMIAL],
       [NEW].[FORMAT],
       [NEW].[INITIALVALUE],
       [NEW].[CALCINITIALVALUE],
       [NEW].[OVERRIDEINITIALVALUE],
       [NEW].[REQUIRED],
       [NEW].[VALIDATION],
       [NEW].[LOW],
       [NEW].[HIGH],
       [NEW].[SYSTEMFIELD],
       [NEW].[TOP],
       [NEW].[LEFT],
       [NEW].[HEIGHT],
       [NEW].[WIDTH],
       [NEW].[FONT],
       [NEW].[VISIBLE],
       [NEW].[ENABLED],
       [NEW].[READONLY],
       [NEW].[MULTILINE],
       [NEW].[ACTUALNAME],
       [NEW].[COMMON],
       [NEW].[UDFCategory],
       [NEW].[ISLOCK],
       [NEW].[SQLSTATEMENT]
  FROM (SELECT 'HAN:'                            AS [FILEPREFIX],
               'TradingName'                     AS [FIELDNAME],
               'System'                          AS [TYPE],
               'Current Handler Trading Name'    AS [PROMPT],
               200                               AS [LENGTH],
               0                                 AS [DECMIAL],
               '@s200'                           AS [FORMAT],
               ''                                AS [INITIALVALUE],
               'N'                               AS [CALCINITIALVALUE],
               'N'                               AS [OVERRIDEINITIALVALUE],
               'N'                               AS [REQUIRED],
               'N'                               AS [VALIDATION],
               0                                 AS [LOW],
               0                                 AS [HIGH],
               'N'                               AS [SYSTEMFIELD],
               0                                 AS [TOP],
               0                                 AS [LEFT],
               0                                 AS [HEIGHT],
               0                                 AS [WIDTH],
               ''                                AS [FONT],
               'Y'                               AS [VISIBLE],
               'Y'                               AS [ENABLED],
               'N'                               AS [READONLY],
               'N'                               AS [MULTILINE],
               'HAN:TradingName'                 AS [ACTUALNAME],
               1                                 AS [COMMON],
               NULL                              AS [UDFCategory],
               0                                 AS [ISLOCK],
               NULL                              AS [SQLSTATEMENT]) [NEW]
       LEFT OUTER JOIN [dbo].[SystemUserDefinedFields] [SUF]
                    ON [SUF].[FILEPREFIX] = [NEW].[FILEPREFIX]
                   AND [SUF].[FIELDNAME]  = [NEW].[FIELDNAME]
 WHERE [SUF].[FILEPREFIX] IS NULL
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.2.40
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.2.41
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 41, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.4.2.41'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
IF EXISTS
  (SELECT TOP 1 1
     FROM SYS.[objects] SO
          INNER JOIN SYS.[default_constraints] DF
                  ON DF.[parent_object_id] = SO.[object_id]
                 AND DF.[name] = 'DF_UndertakingsDate'
                 AND DF.[definition] = '(''19000101'')'
    WHERE SO.[name] = 'Undertakings'
      AND SO.[type] = 'U')
  BEGIN
    EXEC ('ALTER TABLE [dbo].[Undertakings] DROP CONSTRAINT [DF_UndertakingsDate]')
  END
GO

IF EXISTS
  (SELECT TOP 1 1
     FROM SYS.[objects] SO
          LEFT OUTER JOIN SYS.[default_constraints] DF
                       ON DF.[parent_object_id] = SO.[object_id]
                      AND DF.[name] = 'DF_UndertakingsDate'
    WHERE SO.[name] = 'Undertakings'
      AND SO.[type] = 'U'
      AND DF.[object_id] IS NULL)
  BEGIN
    ALTER TABLE [dbo].[Undertakings] ADD  CONSTRAINT [DF_UndertakingsDate]  DEFAULT (GetDate()) FOR [DATE]
  END
GO

IF EXISTS
  (SELECT TOP 1 1
     FROM SYS.[objects] SO
          INNER JOIN SYS.[default_constraints] DF
                  ON DF.[parent_object_id] = SO.[object_id]
                 AND DF.[name] = 'DF_UndertakingsUndDate'
                 AND DF.[definition] = '(''19000101'')'
    WHERE SO.[name] = 'Undertakings'
      AND SO.[type] = 'U')
  BEGIN
    EXEC ('ALTER TABLE [dbo].[Undertakings] DROP CONSTRAINT [DF_UndertakingsUndDate]')
  END
GO

IF EXISTS
  (SELECT TOP 1 1
     FROM SYS.[objects] SO
          LEFT OUTER JOIN SYS.[default_constraints] DF
                       ON DF.[parent_object_id] = SO.[object_id]
                      AND DF.[name] = 'DF_UndertakingsUndDate'
    WHERE SO.[name] = 'Undertakings'
      AND SO.[type] = 'U'
      AND DF.[object_id] IS NULL)
  BEGIN
    ALTER TABLE [dbo].[Undertakings] ADD  CONSTRAINT [DF_UndertakingsUndDate]  DEFAULT (GetDate()) FOR [UNDDATE]
  END
GO

SET NOCOUNT ON

UPDATE UND
   SET UND.[EntryDate] = UND.[DATE]
  FROM [dbo].[Undertakings] UND
 WHERE UND.[EntryDate] IS NULL
GO

SET NOCOUNT OFF

IF EXISTS
  (SELECT TOP 1 1
     FROM SYS.[objects] SO
          INNER JOIN SYS.[columns] SC
                  ON SC.[object_id] = SO.[object_id]
                 AND SC.[name] = 'EntryDate'
    WHERE SO.[name] = 'Undertakings'
      AND SO.[type] = 'U'
      AND SC.[is_nullable] = 1)
  BEGIN
    EXEC ('ALTER TABLE [dbo].[Undertakings] ALTER COLUMN [EntryDate] DATETIME NOT NULL')
  END
GO

IF EXISTS
  (SELECT TOP 1 1
     FROM SYS.[objects] SO
          LEFT OUTER JOIN SYS.[default_constraints] DF
                       ON DF.[parent_object_id] = SO.[object_id]
                      AND DF.[name] = 'DF_UndertakingsEntryDate'
    WHERE SO.[name] = 'Undertakings'
      AND SO.[type] = 'U'
      AND DF.[object_id] IS NULL)
  BEGIN
    EXEC ('ALTER TABLE [dbo].[Undertakings] ADD  CONSTRAINT [DF_UndertakingsEntryDate]  DEFAULT (GetDate()) FOR [EntryDate]')
  END
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.2.41
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.2.43
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 43, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.4.2.43'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
IF EXISTS
  (SELECT TOP 1 1
     FROM sys.objects [obj]
	  WHERE [OBJ].[name] = 'ClientsUDFFormsMapping'
      AND [OBJ].[type] = 'U')
BEGIN
  EXEC ('  
  DELETE CUFM
    FROM [dbo].[ClientUDFForms] CUF
         INNER JOIN [dbo].[ClientsUDFFormsMapping] CUFM
                 ON CUFM.[FormID] = CUF.[FormID]
         LEFT OUTER JOIN [dbo].[Contacts] CON
                      ON CON.[Code] = CUF.[ClientCode]
   WHERE CON.[Code] IS NULL')
END
GO

DELETE CUF
  FROM [dbo].[ClientUDFForms] CUF
       LEFT OUTER JOIN [dbo].[Contacts] CON
                    ON CON.[Code] = CUF.[ClientCode]
 WHERE CON.[Code] IS NULL
GO

IF EXISTS
  (SELECT TOP 1 1
     FROM sys.objects [obj]
	  WHERE [OBJ].[name] = 'ClientsUDFFormsMapping'
      AND [OBJ].[type] = 'U')
BEGIN
  EXEC ('
	INSERT 
    INTO [dbo].[ClientsUDFFormsMapping]
        ([FormID],
         [ClientCode])
	SELECT [CUF].[FormID],
         [CUF].[ClientCode]
    FROM [dbo].[ClientUDFForms] [CUF]
         INNER JOIN [dbo].[Contacts] [CON]
                 ON [CON].[Code] = [CUF].[ClientCode]')
END
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.2.43
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.2.46
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 46, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.4.2.46'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
IF NOT EXISTS
  (SELECT TOP 1 1
     FROM SYS.[objects] SO
          INNER JOIN SYS.[foreign_keys] FK
                  ON FK.[parent_object_id] = SO.[object_id]
                 AND FK.[name] = 'FK_MDF_Matters'
    WHERE SO.[name] = 'MatterDocFolders'
      AND SO.[type] = 'U')
  BEGIN
    EXEC ('
    ALTER 
    TABLE [dbo].[MatterDocFolders]
     WITH CHECK 
      ADD CONSTRAINT [FK_MDF_Matters] 
          FOREIGN KEY([MatterCode])
                  REFERENCES [dbo].[SearchMatters] ([Code])
               ON DELETE CASCADE')

    EXEC ('ALTER TABLE [dbo].[MatterDocFolders] CHECK CONSTRAINT [FK_MDF_Matters]')
  END
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.2.46
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.2.57
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 57, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.4.2.57'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
-- KEYD-3560
IF NOT EXISTS(SELECT TOP 1 1 FROM Settings WHERE KeyName='AllowToDeleteOtherAction')
BEGIN
	INSERT INTO Settings (KeyName, KeyValue ) VALUES ('AllowToDeleteOtherAction','True')
END
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.2.57
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.2.67
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 67, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.4.2.67'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
IF
   EXISTS (SELECT *
             FROM sys.columns COL
		   WHERE COL.[name] = N'SetupPeriod'
		     AND COL.[object_id] = OBJECT_ID(N'matters')) AND
   EXISTS (SELECT *
             FROM sys.columns COL
		   WHERE COL.[name] = N'SetupYear'
		     AND COL.[object_id] = OBJECT_ID(N'matters'))
BEGIN
	IF [dbo].[ISSAM4]() = 1
	BEGIN
		EXEC ('
		UPDATE MAT
		   SET MAT.[SetupPeriod] = 
			   MONTH(DATEADD(M, - (12 + MONTH(PND.[DateValue]) - PER.[NumValue]) % 12 +
			   CASE WHEN DATEPART(DAY, MAT.[Started]) > DATEPART(DAY, PND.[DateValue])
						 THEN 1
					ELSE 0
			   END, MAT.[Started])),
			   MAT.[SetupYear] = YEAR(DATEADD(M, - (12 + MONTH(PND.[DateValue]) - PER.[NumValue]) % 12 +
			   CASE WHEN DATEPART(DAY, MAT.[Started]) > DATEPART(DAY, PND.[DateValue])
						 THEN 1
					ELSE 0
			   END, MAT.[Started])) +
			   YER.[NumValue] - (YEAR(DATEADD(MM, -PER.[NumValue], PND.[DateValue])))
		  FROM [dbo].[matters] AS MAT
			   LEFT OUTER JOIN [dbo].[CtrlDate] AS PND
							ON PND.[Code] = ''PeriodEnd''
			   LEFT OUTER JOIN [dbo].[CtrlNum] AS PER
							ON PER.[Code] = ''CurPeriod''
			   LEFT OUTER JOIN [dbo].[CtrlNum] AS YER
							ON YER.[Code] = ''CurYear''
		 WHERE MAT.[SetupYear] IS NULL
			OR MAT.[SetupPeriod] IS NULL')
	END
	ELSE
	BEGIN
		EXEC ('
		UPDATE MAT 
		   SET MAT.[SetupPeriod] = 
			   MONTH(DATEADD(M, - (12 + MONTH(DATEADD(DD, CON.[PERIODEND], ''1800-12-28'')) - CON.[CURPER]) % 12 +
			   CASE WHEN DATEPART(DAY, MAT.[Started]) > DATEPART(DAY, DATEADD(DD, CON.[PERIODEND], ''1800-12-28''))
	 					 THEN 1
	 			   ELSE 0
			   END, MAT.[Started])),
			   MAT.[SetupYear] = 
			   YEAR(DATEADD(M, - (12 + MONTH(DATEADD(DD, CON.[PERIODEND], ''1800-12-28'')) - CON.[CURPER]) % 12 +
			   CASE WHEN DATEPART(DAY, MAT.[Started]) > DATEPART(DAY, DATEADD(DD, CON.[PERIODEND], ''1800-12-28''))
						THEN 1
					ELSE 0
			   END, MAT.[Started])) +
				   CON.[YEAR] - (YEAR(DATEADD(MM, -[CURPER], DATEADD(DD, CON.[PERIODEND], ''1800-12-28''))))
		  FROM [dbo].[matters] AS MAT
			   CROSS APPLY [dbo].[control] AS CON
		 WHERE MAT.[SetupYear] IS NULL
			OR MAT.[SetupPeriod] IS NULL')
	END
END
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.2.67
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.2.77
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 77, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.4.2.77'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
IF NOT EXISTS
  (SELECT TOP 1 1
     FROM [dbo].[CasePlanUDFForms])
  BEGIN
    INSERT
      INTO [dbo].[CasePlanUDFForms]
          ([FormID],
           [CasePlan])
    SELECT UF.[FormID],
           UF.[CasePlan]
      FROM [dbo].[UDFForms] UF
  END
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.2.77
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
--Keep this to be safe START
SET NOCOUNT ON
UPDATE #SCRIPT SET [MajorVersion] = 5,
                   [MinorVersion] = 4,
                   [Build] = 3,
                   [Revision] = 1,
                   [CompatibleVersion] = 'Build 5.4.3.1'
SET NOCOUNT OFF
--Keep this to be safe END
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.3.1
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 1, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.4.3.1'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
UPDATE [CAN]
       SET [CAN].[Retired] = CASE WHEN RTRIM(ISNULL([CAN].[Retired], 'N')) = 'Y'
                                       THEN 'Y'
                                  ELSE 'N' END
  FROM [dbo].[CaseAssociatesNames] [CAN]
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.3.1
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.3.1002
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 1002, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.4.3.1002'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
-- Correct SystemUserDefinedFields settings for User fields in matters - KEYD-3737
UPDATE [SUF]
   SET [SUF].[LENGTH] = SC.[max_length],
       [SUF].[FORMAT] = '@s' + CONVERT(VARCHAR(10), SC.[max_length])
  FROM SYS.[objects] SO
       INNER JOIN SYS.[columns] SC
               ON SC.[object_id] = SO.[object_id]
              AND SC.[name] LIKE 'User%'
       INNER JOIN [dbo].[SystemUserDefinedFields] [SUF]
               ON SUF.[FILEPREFIX] = 'MAT:'
              AND CONVERT(VARCHAR(100), [SUF].[FIELDNAME]) = CONVERT(VARCHAR(100), SC.[name])
 WHERE SO.[name] = 'matters'
   AND (   SUF.[LENGTH] <> SC.[max_length]
        OR SUF.[FORMAT] <> '@s' + CONVERT(VARCHAR(10), SC.[max_length]))
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.3.1002
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.3.1005
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 1005, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.4.3.1005'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
UPDATE [CAN]
       SET [CAN].[Retired] = CASE WHEN RTRIM(ISNULL([CAN].[Retired], 'N')) = 'Y'
                                       THEN 'Y'
                                  ELSE 'N' END
  FROM [dbo].[CaseAssociatesNames] [CAN]
GO

IF NOT EXISTS
  (SELECT TOP 1 1
     FROM [dbo].[SystemUserDefinedFields] [SUF]
    WHERE [SUF].[FILEPREFIX] = 'LCN:'
      AND [SUF].[FIELDNAME] = 'Occupation')
BEGIN
  INSERT
    INTO [dbo].[SystemUserDefinedFields]
        ([FILEPREFIX],
         [FIELDNAME],
         [TYPE],
         [PROMPT],
         [LENGTH],
         [DECMIAL],
         [FORMAT],
         [INITIALVALUE],
         [CALCINITIALVALUE],
         [OVERRIDEINITIALVALUE],
         [REQUIRED],
         [VALIDATION],
         [LOW],
         [HIGH],
         [SYSTEMFIELD],
         [TOP],
         [LEFT],
         [HEIGHT],
         [WIDTH],
         [FONT],
         [VISIBLE],
         [ENABLED],
         [READONLY],
         [MULTILINE],
         [ACTUALNAME],
         [COMMON],
         [ISLOCK])
  VALUES('LCN:',
         'Occupation',
         'System',
         'Occupation',
         20,
         0,
         '@s20',
         '',
         'N',
         'N',
         'N',
         'N',
         0,
         0,
         'N',
         0,
         0,
         0,
         0,
         '',
         'Y',
         'Y',
         'N',
         'N',
         '',
         1,
         0)
END
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.3.1005
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.3.1007
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 1007, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.4.3.1007'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
/*
	Author:      John Ginnane
	Date:        2016-07-15
	Description: The following will check if the system code 'WRI' (Write Off)
	             is present in the Tasks Codes table. If it's missing it will 
	             put it back into the system.
*/

IF (SELECT TOP 1 [CODE] FROM [dbo].[TasksCodes] WHERE [CODE] = 'WRI') IS NULL
BEGIN
	INSERT INTO [dbo].[TasksCodes] (
	       [CODE],
		   [DESC],
		   [DEFAULT],
		   [UDFLEN1],
		   [UDFLEN2],
		   [UDFLEN3],
		   [UDFLEN4],
		   [UDFLEN5],
		   [UDFLEN6],
		   [UDFPROMPT1],
		   [UDFPROMPT2],
		   [UDFPROMPT3],
		   [UDFPROMPT4],
		   [UDFPROMPT5],
		   [UDFPROMPT6],
		   [CHARGEAMT],
		   [REC_IRR],
		   [CHARGELEVEL],
		   [AxleTask])
	SELECT 'WRI',
	       'Write Off',
		   0,
		   0,
		   0,
		   0,
		   0,
		   0,
		   0,
		   '',
		   '',
		   '',
		   '',
		   '',
		   '',
		   0,
		   '',
		   'C',
		   'N'

END
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.3.1007
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.3.1018
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 1018, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.4.3.1018'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
-- Pino 2016-07-19 - Fix incorrect [ACTUALNAME] for [MAT:] entries
UPDATE [SUF]
   SET [SUF].[ACTUALNAME] = REPLACE([SUF].[ACTUALNAME], 'TME1:', 'TEA1:')
  FROM [dbo].[SystemUserDefinedFields] [SUF]
 WHERE [SUF].[FILEPREFIX] = 'MAT:'
   AND [SUF].[ACTUALNAME] LIKE 'TME1:%'
GO

-- Pino 2016-07-19 - MAT:FECode should *not* have an [ACTUALNAME] value
UPDATE [SUF]
   SET [SUF].[ACTUALNAME] = ''
  FROM [dbo].[SystemUserDefinedFields] [SUF]
 WHERE [SUF].[FILEPREFIX] = 'MAT:'
   AND [SUF].[FIELDNAME] = 'FECode'
   AND RTRIM(ISNULL([SUF].[ACTUALNAME], '')) <> ''
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.3.1018
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.3.1020
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 1020, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.4.3.1020'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
/* Author:      John Ginnane
   Date:        2016-08-04
   Description: Adds two new matter secretary fields (KEYD-3402) 
                for the KHDocGen:
                * MAT:SecretaryName
                * MAT:SecretaryEmail
*/

IF NOT EXISTS(SELECT TOP 1 1 
                FROM [dbo].[SystemUserDefinedFields] 
               WHERE [FILEPREFIX] = 'MAT:' 
                 AND [FIELDNAME] = 'SecretaryName')
BEGIN
	INSERT INTO [dbo].[SystemUserDefinedFields] (
		   [FILEPREFIX],
		   [FIELDNAME],
		   [TYPE],
		   [PROMPT],
		   [LENGTH],
		   [DECMIAL],
		   [FORMAT],
		   [INITIALVALUE],
		   [CALCINITIALVALUE],
		   [OVERRIDEINITIALVALUE],
		   [REQUIRED],
		   [VALIDATION],
		   [LOW],
		   [HIGH],
		   [SYSTEMFIELD],
		   [TOP],
		   [LEFT],
		   [HEIGHT],
		   [WIDTH],
		   [FONT],
		   [VISIBLE],
		   [ENABLED],
		   [READONLY],
		   [MULTILINE],
		   [ACTUALNAME],
		   [COMMON],
		   [UDFCategory],
		   [ISLOCK],
		   [SQLSTATEMENT])
	VALUES 
		  ('MAT:',
		   'SecretaryName',
		   'System',
		   'Secretary Name',
		   50,
		   0,
		   '@s50',
		   '',
		   '',
		   '',
		   'N',
		   'N',
		   0,
		   0,
		   'N',
		   0,
		   0,
		   0,
		   0,
		   '',
		   'Y',
		   'Y',
		   'N',
		   'N',
		   'SEC:Name',
		   0,
		   0,
		   0,
		   '')
END

IF NOT EXISTS(SELECT TOP 1 1 
                FROM [dbo].[SystemUserDefinedFields] 
               WHERE [FILEPREFIX] = 'MAT:' 
                 AND [FIELDNAME] = 'SecretaryEmail')
BEGIN
	INSERT INTO [dbo].[SystemUserDefinedFields] (
		   [FILEPREFIX],
		   [FIELDNAME],
		   [TYPE],
		   [PROMPT],
		   [LENGTH],
		   [DECMIAL],
		   [FORMAT],
		   [INITIALVALUE],
		   [CALCINITIALVALUE],
		   [OVERRIDEINITIALVALUE],
		   [REQUIRED],
		   [VALIDATION],
		   [LOW],
		   [HIGH],
		   [SYSTEMFIELD],
		   [TOP],
		   [LEFT],
		   [HEIGHT],
		   [WIDTH],
		   [FONT],
		   [VISIBLE],
		   [ENABLED],
		   [READONLY],
		   [MULTILINE],
		   [ACTUALNAME],
		   [COMMON],
		   [UDFCategory],
		   [ISLOCK],
		   [SQLSTATEMENT])
	VALUES 
		  ('MAT:',
		   'SecretaryEmail',
		   'System',
		   'Secretary Email Address',
		   100,
		   0,
		   '@s100',
		   '',
		   '',
		   '',
		   'N',
		   'N',
		   0,
		   0,
		   'N',
		   0,
		   0,
		   0,
		   0,
		   '',
		   'Y',
		   'Y',
		   'N',
		   'N',
		   'SEC:Email',
		   0,
		   0,
		   0,
		   '')
END

GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.3.1020
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
--Keep this to be safe START
SET NOCOUNT ON
UPDATE #SCRIPT SET [MajorVersion] = 5,
                   [MinorVersion] = 4,
                   [Build] = 4,
                   [Revision] = 1,
                   [CompatibleVersion] = 'Build 5.4.4.1'
SET NOCOUNT OFF
--Keep this to be safe END
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.4.1007
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 1007, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.4.4.1007'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
--Create a couple of default values - data valid as of 2016-09-01
IF NOT EXISTS
  (SELECT TOP 1 1
     FROM [dbo].[RegisteredPostTypes])
  BEGIN
    -- http://www.anpost.ie/AnPost/PostalRates/Registered+Post.htm
    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('National Letter/Postcard',
           6.25,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('National Large Envelope/Package (100 g)',
           6.25,
           1)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('National Large Envelope/Package (250 g)',
           6.75,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('National Large Envelope/Package (500 g)',
           7.75,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('National Large Envelope/Package (1 kg)',
           10.75,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('National Parcel (up to 1 kg)',
           11.10,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('National Package or Parcel (1.5 - 2 kg)',
           12.90,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('National Parcel (2.5 - 3 kg)',
           14.60,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('National Parcel (3.5 - 4 kg)',
           17.10,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('National Parcel (4.5 - 5 kg)',
           19.10,
           0)

    -- http://www.anpost.ie/AnPost/PostalRates/Registered+Post+International.htm 
    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('Britain Letter/Postcard',
           6.25,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('Britain Large Envelope (100 g)',
           7.20,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('Britain Large Envelope (250 g)',
           8.85,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('Britain Large Envelope (500 g)',
           10.05,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('Britain Packet (100 g)',
           9.05,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('Britain Packet (250 g)',
           10.05,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('Britain Packet (500 g)',
           11.05,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('Britain Packet (1 kg)',
           13.55,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('Britain Packet (1.5 to 2 kg)',
           16.80,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('Britain Parcel (up to 1 kg)',
           25.60,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('Britain Parcel (1.5 kg)',
           29.60,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('Britain Parcel (2 kg)',
           33.10,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('Britain Parcel (2.5 kg)',
           35.60,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('Britain Parcel (3 kg)',
           39.60,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('Britain Parcel (3.5 kg)',
           41.60,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('Britain Parcel (4 kg)',
           43.60,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('Britain Parcel (4.5 kg)',
           45.60,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('Britain Parcel (5 kg)',
           47.60,
           0)





    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('Europe Letter/Postcard',
           6.25,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('Europe Large Envelope (100 g)',
           7.20,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('Europe Large Envelope (250 g)',
           8.85,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('Europe Large Envelope (500 g)',
           10.05,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('Europe Packet (100 g)',
           9.05,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('Europe Packet (250 g)',
           10.05,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('Europe Packet (500 g)',
           11.05,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('Europe Packet (1 kg)',
           13.55,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('Europe Packet (1.5 to 2 kg)',
           16.80,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('Europe Parcel (up to 1 kg)',
           30.60,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('Europe Parcel (1.5 kg)',
           35.60,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('Europe Parcel (2 kg)',
           37.60,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('Europe Parcel (2.5 kg)',
           41.60,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('Europe Parcel (3 kg)',
           45.60,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('Europe Parcel (3.5 kg)',
           51.60,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('Europe Parcel (4 kg)',
           55.60,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('Europe Parcel (4.5 kg)',
           60.60,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('Europe Parcel (5 kg)',
           65.60,
           0)





    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('International Letter/Postcard',
           6.25,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('International Large Envelope (100 g)',
           7.20,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('International Large Envelope (250 g)',
           8.85,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('International Large Envelope (500 g)',
           10.05,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('International Packet (100 g)',
           9.05,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('International Packet (250 g)',
           10.05,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('International Packet (500 g)',
           11.05,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('International Packet (1 kg)',
           16.80,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('International Packet (1.5 to 2 kg)',
           23.05,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('International Parcel (up to 1 kg)',
           30.60,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('International Parcel (1.5 kg)',
           35.60,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('International Parcel (2 kg)',
           37.60,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('International Parcel (2.5 kg)',
           41.60,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('International Parcel (3 kg)',
           45.60,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('International Parcel (3.5 kg)',
           51.60,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('International Parcel (4 kg)',
           55.60,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('International Parcel (4.5 kg)',
           60.60,
           0)

    INSERT
      INTO [dbo].[RegisteredPostTypes]
          ([Description],
           [DefaultChargeValue],
           [SetAsDefault])
    VALUES('International Parcel (5 kg)',
           65.60,
           0)
  END
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/
UPDATE 
	Matters 
SET 
	BillingMethod = null
WHERE 
	BillingMethod NOT IN ('C','T')
	
GO

UPDATE 
	CONTACTS 
SET 
	BillingMethod = null
WHERE 
	BillingMethod NOT IN ('C','T')
GO
/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.4.1007
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.4.1015
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 1015, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.4.4.1015'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
UPDATE [CLT]
   SET [CLT].[CLADDR] = [CNT].[Address]
  FROM [dbo].[client] [CLT]
       INNER JOIN [dbo].[Contacts] [CNT]
               ON [CNT].[Code] = [CLT].[CLCODE]
 WHERE ISNULL([CLT].[CLADDR], '') <> ISNULL([CNT].[Address], '')
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.4.1015
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.4.1024
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 1024, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.4.4.1024'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
-- correct inconsistency linking TimeEntry to DebtCostingLedger through
-- the [TrackRef] column. Should be [Docket] instead.
UPDATE [TIE]
   SET [TIE].[Docket] = [DCL].[POSTINGREF],
       [TIE].[TrackRef] = 0
  FROM [dbo].[DebtCostingLedger] [DCL]
       INNER JOIN [dbo].[TimeEntry] [TIE]
               ON [TIE].[TrackRef] = [DCL].[POSTINGREF]
              AND [TIE].[TrackRef] <> 0
GO

IF NOT EXISTS(SELECT TOP 1 1 FROM Settings where KeyName = 'EFTDefaultON')
BEGIN
INSERT INTO Settings(KeyName,KeyValue) VALUES('EFTDefaultON','N')
END

GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.4.1024
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
--Keep this to be safe START
SET NOCOUNT ON
UPDATE #SCRIPT SET [MajorVersion] = 5,
                   [MinorVersion] = 4,
                   [Build] = 5,
                   [Revision] = 1,
                   [CompatibleVersion] = 'Build 5.4.5.1'
SET NOCOUNT OFF
--Keep this to be safe END
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.5.1004
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 1004, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.4.5.1004'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
 
 IF EXISTS(SELECT 1 FROM KYCType WHERE Description = 'Enhanced Due Diligence')
BEGIN
    UPDATE 
       [KYCType]
    SET 
       [Editable] = 0
    WHERE 
       [Description] = 'Enhanced Due Diligence'
END
ELSE
BEGIN
    INSERT INTO 
       KYCType([Description],Editable) 
    VALUES('Enhanced Due Diligence',0)
END

GO

IF EXISTS(SELECT 1 FROM KYCType WHERE Description = 'Simplified Client Due Diligence (SCDD)')
BEGIN
    UPDATE 
       [KYCType]
    SET 
       [Editable] = 0
    WHERE 
       [Description] = 'Simplified Client Due Diligence (SCDD)'
END
ELSE
BEGIN
    INSERT INTO 
       KYCType([Description],Editable) 
    VALUES('Simplified Client Due Diligence (SCDD)',0)
END

GO

IF EXISTS(SELECT 1 FROM KYCType WHERE Description = 'Standard Client Due Diligence') 
BEGIN
    UPDATE 
       [KYCType]
    SET 
       [Editable] = 0
    WHERE 
       [Description] = 'Standard Client Due Diligence'
END
ELSE
BEGIN
    INSERT INTO 
       KYCType([Description],Editable) 
    VALUES('Standard Client Due Diligence',0)
END

GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.5.1004
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.5.1020
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 1020, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.4.5.1020'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
--Create a placeholder row for [dbo].[EFTDetails]
IF NOT EXISTS
  (SELECT TOP 1 1
     FROM [dbo].[EFTDetails] [EFD])
  BEGIN
    INSERT
      INTO [dbo].[EFTDetails]
          ([EFTYN])
    VALUES('N')
  END
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.5.1020
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.5.1032
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 1032, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.4.5.1032'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
--KEYD-4266 In case there are rows in the database where the diary status is 1,
--          but the DiaryDelegation status = 0
UPDATE [DEL]
   SET [DEL].[STATUS] = 1
  FROM [dbo].[diary] [DIA]
       INNER JOIN [dbo].[DiaryDelegations] [DEL]
               ON [DEL].[ACTIONID] = [DIA].[ACTIONID]
 WHERE [DIA].[STATUS] = 1
   AND [DEL].[STATUS] = 0
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.5.1032
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/
--Keep this to be safe START
SET NOCOUNT ON
UPDATE #SCRIPT SET [MajorVersion] = 5,
                   [MinorVersion] = 4,
                   [Build] = 6,
                   [Revision] = 1,
                   [CompatibleVersion] = 'Build 5.4.6.1'
SET NOCOUNT OFF
--Keep this to be safe END
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.6.2
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * START
 *
 ****************************************************************************************************************/

SET NOCOUNT ON
UPDATE #SCRIPT SET [Revision] = 2, --While you could set Major, Minor or Build here, too, this should be unlikely.
                   [CompatibleVersion] = 'Build 5.4.6.2'
SET NOCOUNT OFF

/****************************************************************************************************************
 *
 * Please make sure that whatever Major/Minor/Build/Revision setting is produced in the preceding statement,
 * it is NEVER used again in this script, otherwise the code below will prevent it from executing.
 *
 ****************************************************************************************************************/
IF EXISTS
  (SELECT TOP 1 1 
     FROM [dbo].[KYScriptLog] SKL
          INNER JOIN #SCRIPT SCR
                  ON SCR.[MajorVersion] = SKL.[MajorVersion]
                 AND SCR.[MinorVersion] = SKL.[MinorVersion]
                 AND SCR.[Build] = SKL.[Build]
                 AND SCR.[Revision] = SKL.[Revision]
                 AND SCR.[ScriptName] = SKL.[COMMENT])
BEGIN
  -- This will prevent the script from running if it has already been run before
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

/************************************************************************************************************
 *
 * Log the unsuccessful execution of this block. If the script fails, it will not run through to the end
 * where the **FAILED** text is removed from the [COMMENT]
 *
 ************************************************************************************************************/
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
SELECT GETDATE(),
       SCR.[MajorVersion],
       SCR.[MinorVersion],
       SCR.[Build],
       SCR.[Revision],
       SCR.[CompatibleVersion],
       SCR.[ScriptName] + '' **FAILED**''
  FROM #SCRIPT SCR

SET NOCOUNT OFF'

EXEC (@COMMAND)
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements after
 * this comment
 *
 ****************************************************************************/
UPDATE [MAT]
   SET [MAT].[NoWinNoFee] = 'N'
  FROM [dbo].[matters] [MAT]
 WHERE [MAT].[NoWinNoFee] IS NULL
GO
/****************************************************************************
 *
 * This is where your actual script should go. Insert statements before
 * this comment
 *
 ****************************************************************************/

/****************************************************************************
 *
 * Log the successful execution of this block
 *
 ****************************************************************************/
--PLEASE Remove **WIP - SUCCESS** from the following statement when work on this block is complete.
DECLARE @COMMAND VARCHAR(MAX)

SET @COMMAND = 'SET NOCOUNT ON

UPDATE SKL
   SET SKL.[COMMENT] = SCR.[ScriptName]'

--SET @COMMAND = @COMMAND + ' + '' **WIP - SUCCESS**''' --comment this line out when complete

SET @COMMAND = @COMMAND  + '
  FROM [dbo].[KYScriptLog] SKL
       INNER JOIN #SCRIPT SCR
               ON SCR.[MajorVersion] = SKL.[MajorVersion]
              AND SCR.[MinorVersion] = SKL.[MinorVersion]
              AND SCR.[Build] = SKL.[Build]
              AND SCR.[Revision] = SKL.[Revision]
              AND SKL.[COMMENT] = SCR.[ScriptName] + '' **FAILED**''

SET NOCOUNT OFF'

EXEC (@COMMAND)
   
GO

-- This will ensure that scripts after this block will run successfully.
SET NOEXEC OFF
SET NOCOUNT OFF
GO
/****************************************************************************************************************
 *
 * SCRIPT CHANGES FOR BUILD 5.4.6.2
 * Block IS **COMPLETE** - Do not make changes to this block - add changes to the last block, below
 * END
 *
 ****************************************************************************************************************/

--DELETE [dbo].[KYScriptLog] WHERE [COMMENT] LIKE '% **WIP - SUCCESS**' 
/****************************************************************************************************************
 * DO NOT INSERT CODE HERE. Put it before "Log the successful execution of this block" - see above
 ****************************************************************************************************************/
/* The following block of code MUST remain at the end of this file START */
DELETE KGC
  FROM [dbo].[KHCtlGroupControls] KGC
       INNER JOIN [dbo].[KHCtlMaster] KCM
               ON KCM.[id] = KGC.[masterid]
       INNER JOIN [dbo].[KHCtlGroups] KCG
               ON KCG.[id] = KGC.[groupid]
 WHERE KCM.[Deleted] = 1
    OR KCM.[FriendlyName] = ''
GO
/* The following block of code MUST remain at the end of this file END */
